/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.relation;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.relation.OngoingWhereClause;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.relation.TokenRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.lhs.TokenLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultRelation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultTokenRelationBuilder
implements TokenRelationBuilder<Relation> {
    private final Iterable<CqlIdentifier> identifiers;

    public DefaultTokenRelationBuilder(@NonNull Iterable<CqlIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    @NonNull
    public Relation build(@NonNull String operator, @Nullable Term rightOperand) {
        return new DefaultRelation(new TokenLeftOperand(this.identifiers), operator, rightOperand);
    }

    @Immutable
    public static class Fluent<StatementT extends OngoingWhereClause<StatementT>>
    implements TokenRelationBuilder<StatementT> {
        private final OngoingWhereClause<StatementT> statement;
        private final TokenRelationBuilder<Relation> delegate;

        public Fluent(@NonNull OngoingWhereClause<StatementT> statement, @NonNull Iterable<CqlIdentifier> identifiers) {
            this.statement = statement;
            this.delegate = new DefaultTokenRelationBuilder(identifiers);
        }

        @Override
        @NonNull
        public StatementT build(@NonNull String operator, @Nullable Term rightOperand) {
            return this.statement.where((Relation)this.delegate.build(operator, rightOperand));
        }
    }
}

