/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;

public class RecipientRewriteTableConfiguration {
    public static final boolean RECURSIVE_MAPPING_ENABLED = true;
    public static final int DEFAULT_ENABLED_MAPPING_LIMIT = 10;
    public static final int DISABLED_MAPPING_LIMIT = 0;
    public static final RecipientRewriteTableConfiguration DEFAULT_ENABLED = new RecipientRewriteTableConfiguration(true, 10);
    public static final RecipientRewriteTableConfiguration DISABLED = new RecipientRewriteTableConfiguration(false, 0);
    private final int mappingLimit;
    private final boolean recursive;

    @VisibleForTesting
    public RecipientRewriteTableConfiguration(boolean recursive, int mappingLimit) {
        Preconditions.checkArgument((mappingLimit == 0 || recursive ? 1 : 0) != 0, (Object)"mappingLimit can not be different than 0 when recursive mode is disabled");
        this.recursive = recursive;
        this.mappingLimit = mappingLimit;
    }

    public static RecipientRewriteTableConfiguration fromConfiguration(HierarchicalConfiguration<ImmutableNode> config) throws ConfigurationException {
        int mappingLimit;
        boolean recursive = config.getBoolean("recursiveMapping", true);
        if (recursive) {
            mappingLimit = config.getInt("mappingLimit", 10);
            RecipientRewriteTableConfiguration.checkMappingLimit(mappingLimit);
        } else {
            mappingLimit = 0;
        }
        return new RecipientRewriteTableConfiguration(recursive, mappingLimit);
    }

    private static void checkMappingLimit(int mappingLimit) throws ConfigurationException {
        if (mappingLimit < 1) {
            throw new ConfigurationException("The minimum mappingLimit is 1");
        }
    }

    public int getMappingLimit() {
        return this.mappingLimit;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public final boolean equals(Object other) {
        if (other instanceof RecipientRewriteTableConfiguration) {
            RecipientRewriteTableConfiguration that = (RecipientRewriteTableConfiguration)other;
            return Objects.equals(this.mappingLimit, that.mappingLimit) && Objects.equals(this.recursive, that.recursive);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mappingLimit, this.recursive);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mappingLimit", this.mappingLimit).add("recursive", this.recursive).toString();
    }
}

