/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.delegation.Delegate;
import org.apache.james.jmap.delegation.DelegateGet$;
import org.apache.james.jmap.delegation.DelegateGetRequest;
import org.apache.james.jmap.delegation.DelegateGetResponse;
import org.apache.james.jmap.delegation.DelegateGetResult;
import org.apache.james.jmap.delegation.DelegateGetResult$;
import org.apache.james.jmap.delegation.DelegationId$;
import org.apache.james.jmap.delegation.ForbiddenAccountManagementException;
import org.apache.james.jmap.json.DelegationSerializer$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001B\n\u0015\u0001}A\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tu\u0001\u0011\t\u0011)A\u0005e!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u00115\u0003!Q1A\u0005\u00029C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\u0006/\u0002!\t\u0001\u0017\u0005\bO\u0002\u0011\r\u0011\"\u0011i\u0011\u0019i\b\u0001)A\u0005S\"9a\u0010\u0001b\u0001\n\u0003z\b\u0002CA\u0010\u0001\u0001\u0006I!!\u0001\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$!9\u0011q\u000b\u0001\u0005B\u0005e\u0003bBA=\u0001\u0011%\u00111\u0010\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\ty\u000b\u0001C\u0005\u0003c\u0013\u0011\u0003R3mK\u001e\fG/Z$fi6+G\u000f[8e\u0015\t)b#\u0001\u0004nKRDw\u000e\u001a\u0006\u0003/a\tAA[7ba*\u0011\u0011DG\u0001\u0006U\u0006lWm\u001d\u0006\u00037q\ta!\u00199bG\",'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0004O!RS\"\u0001\u000b\n\u0005%\"\"\u0001G'fi\"|GMU3rk&\u0014\u0018N\\4BG\u000e|WO\u001c;JIB\u00111FL\u0007\u0002Y)\u0011QFF\u0001\u000bI\u0016dWmZ1uS>t\u0017BA\u0018-\u0005I!U\r\\3hCR,w)\u001a;SKF,Xm\u001d;\u0002\u001b5,GO]5d\r\u0006\u001cGo\u001c:z+\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\r\t\u0007/\u001b\u0006\u0003oa\tq!\\3ue&\u001c7/\u0003\u0002:i\tiQ*\u001a;sS\u000e4\u0015m\u0019;pef\fa\"\\3ue&\u001cg)Y2u_JL\b%A\btKN\u001c\u0018n\u001c8TkB\u0004H.[3s+\u0005i\u0004C\u0001 B\u001b\u0005y$B\u0001!\u0017\u0003\u0019\u0011x.\u001e;fg&\u0011!i\u0010\u0002\u0010'\u0016\u001c8/[8o'V\u0004\b\u000f\\5fe\u0006\u00012/Z:tS>t7+\u001e9qY&,'\u000fI\u0001\u0012g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014X#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%3\u0012\u0001B2pe\u0016L!a\u0013%\u0003#M+7o]5p]R\u0013\u0018M\\:mCR|'/\u0001\ntKN\u001c\u0018n\u001c8Ue\u0006t7\u000f\\1u_J\u0004\u0013a\u00043fY\u0016<\u0017\r^5p]N#xN]3\u0016\u0003=\u0003\"\u0001\u0015+\u000e\u0003ES!!\u000e*\u000b\u0005MC\u0012\u0001B;tKJL!!V)\u0003\u001f\u0011+G.Z4bi&|gn\u0015;pe\u0016\f\u0001\u0003Z3mK\u001e\fG/[8o'R|'/\u001a\u0011\u0002\rqJg.\u001b;?)\u0015I&l\u0017/^!\t9\u0003\u0001C\u00031\u0013\u0001\u0007!\u0007C\u0003<\u0013\u0001\u0007Q\bC\u0003E\u0013\u0001\u0007a\tC\u0003N\u0013\u0001\u0007q\n\u000b\u0002\n?B\u0011\u0001-Z\u0007\u0002C*\u0011!mY\u0001\u0007S:TWm\u0019;\u000b\u0003\u0011\fQA[1wCbL!AZ1\u0003\r%s'.Z2u\u0003)iW\r\u001e5pI:\u000bW.Z\u000b\u0002SB\u0011!N\u001f\b\u0003Wbt!\u0001\\<\u000f\u000554hB\u00018v\u001d\tyGO\u0004\u0002qg6\t\u0011O\u0003\u0002s=\u00051AH]8pizJ\u0011!H\u0005\u00037qI!!\u0007\u000e\n\u0005]A\u0012BA%\u0017\u0013\tI\b*\u0001\u0006J]Z|7-\u0019;j_:L!a\u001f?\u0003\u00155+G\u000f[8e\u001d\u0006lWM\u0003\u0002z\u0011\u0006YQ.\u001a;i_\u0012t\u0015-\\3!\u0003Q\u0011X-];je\u0016$7)\u00199bE&d\u0017\u000e^5fgV\u0011\u0011\u0011\u0001\t\u0007\u0003\u0007\tY!!\u0005\u000f\t\u0005\u0015\u0011q\u0001\t\u0003a\nJ1!!\u0003#\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\b\u0005\r\u0019V\r\u001e\u0006\u0004\u0003\u0013\u0011\u0003\u0003BA\n\u00033q1a[A\u000b\u0013\r\t9\u0002S\u0001\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\n\t\u0005m\u0011Q\u0004\u0002\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\u000b\u0007\u0005]\u0001*A\u000bsKF,\u0018N]3e\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\u0011\u0002\u0015\u001d,GOU3rk\u0016\u001cH\u000f\u0006\u0004\u0002&\u0005u\u0012Q\n\t\b\u0003O\t\t$a\u000e+\u001d\u0011\tI#!\f\u000f\u0007A\fY#C\u0001$\u0013\r\tyCI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019$!\u000e\u0003\r\u0015KG\u000f[3s\u0015\r\tyC\t\t\u0005\u0003O\tI$\u0003\u0003\u0002<\u0005U\"!C#yG\u0016\u0004H/[8o\u0011\u001d\tyD\u0004a\u0001\u0003\u0003\na\"\\1jY\n|\u0007pU3tg&|g\u000e\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9\u0005G\u0001\b[\u0006LGNY8y\u0013\u0011\tY%!\u0012\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\"9\u0011q\n\bA\u0002\u0005E\u0013AC5om>\u001c\u0017\r^5p]B\u0019q)a\u0015\n\u0007\u0005U\u0003J\u0001\u0006J]Z|7-\u0019;j_:\f\u0011\u0002Z8Qe>\u001cWm]:\u0015\u0015\u0005m\u0013QNA9\u0003g\n)\b\u0005\u0004\u0002^\u0005\r\u0014qM\u0007\u0003\u0003?R1!!\u0019\u001d\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c\u0018\u0002BA3\u0003?\u0012\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u0007\u001d\nI'C\u0002\u0002lQ\u0011Q#\u00138w_\u000e\fG/[8o/&$\bnQ8oi\u0016DH\u000fC\u0004\u0002p=\u0001\r!!\u0001\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\t\u000f\u0005=s\u00021\u0001\u0002h!9\u0011qH\bA\u0002\u0005\u0005\u0003BBA<\u001f\u0001\u0007!&A\u0004sKF,Xm\u001d;\u0002-\u001d,G\u000fR3mK\u001e\fG/Z$fiJ+7\u000f]8og\u0016$b!! \u0002\u0018\u0006e\u0005CBA@\u0003\u001b\u000b\t*\u0004\u0002\u0002\u0002*!\u00111QAC\u0003%\u0001XO\u00197jg\",'OC\u0002$\u0003\u000fS1!SAE\u0015\t\tY)A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005=\u0015\u0011\u0011\u0002\u0006'6{gn\u001c\t\u0004W\u0005M\u0015bAAKY\t\tB)\u001a7fO\u0006$XmR3u%\u0016\u001cX\u000f\u001c;\t\r\u0005]\u0004\u00031\u0001+\u0011\u001d\ty\u0004\u0005a\u0001\u0003\u0003\n\u0011cZ3u\u0003V$\bn\u001c:ju\u0016$Wk]3s)\u0019\ti(a(\u0002.\"9\u0011\u0011U\tA\u0002\u0005\r\u0016\u0001\u00032bg\u0016,6/\u001a:\u0011\t\u0005\u0015\u0016\u0011V\u0007\u0003\u0003OS!!\u0013\r\n\t\u0005-\u0016q\u0015\u0002\t+N,'O\\1nK\"1\u0011qO\tA\u0002)\n!#[:EK2,w-\u0019;fIJ+\u0017/^3tiR!\u00111WA]!\r\t\u0013QW\u0005\u0004\u0003o\u0013#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u007f\u0011\u0002\u0019AA!\u0001")
public class DelegateGetMethod
implements MethodRequiringAccountId<DelegateGetRequest> {
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final DelegationStore delegationStore;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    public DelegationStore delegationStore() {
        return this.delegationStore;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    @Override
    public Either<Exception, DelegateGetRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return DelegationSerializer$.MODULE$.deserializeDelegateGetRequest((JsValue)invocation.arguments()).asEither().left().map((Function1 & Serializable)errors -> ResponseSerializer$.MODULE$.asException((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors));
    }

    @Override
    public Publisher<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, DelegateGetRequest request) {
        SMono sMono;
        Properties requestedProperties = (Properties)request.properties().getOrElse((Function0 & Serializable)() -> DelegateGet$.MODULE$.allProperties());
        Properties properties = requestedProperties.$minus$minus(DelegateGet$.MODULE$.allProperties());
        if (properties.isEmpty()) {
            sMono = this.getDelegateGetResponse(request, mailboxSession).map((Function1 & Serializable)result -> result.asResponse(request.accountId())).map((Function1 & Serializable)response -> new Invocation(this.methodName(), (JsObject)DelegationSerializer$.MODULE$.serialize((DelegateGetResponse)response, requestedProperties).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.invocation().methodCallId()));
        } else if (properties != null) {
            Properties properties2 = properties;
            sMono = SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, new StringBuilder(41).append("The following properties [").append(properties2.format()).append("] do not exist.").toString(), invocation.invocation().methodCallId()));
        } else {
            throw new MatchError((Object)properties);
        }
        return sMono.map((Function1 & Serializable)x$1 -> new InvocationWithContext((Invocation)x$1, invocation.processingContext()));
    }

    private SMono<DelegateGetResult> getDelegateGetResponse(DelegateGetRequest request, MailboxSession mailboxSession) {
        return SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)this.isDelegatedRequest(mailboxSession))).filter((Function1 & Serializable)isDelegated -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)isDelegated))).flatMap((Function1 & Serializable)x$2 -> SMono$.MODULE$.error((Throwable)new ForbiddenAccountManagementException())).switchIfEmpty(this.getAuthorizedUser(mailboxSession.getUser(), request));
    }

    private SMono<DelegateGetResult> getAuthorizedUser(Username baseUser, DelegateGetRequest request) {
        return SFlux$.MODULE$.apply(this.delegationStore().authorizedUsers(baseUser)).map((Function1 & Serializable)authorizedUser -> new Delegate(DelegationId$.MODULE$.from(baseUser, (Username)authorizedUser), (Username)authorizedUser)).collectSeq().map((Function1 & Serializable)delegates -> DelegateGetResult$.MODULE$.from((scala.collection.immutable.Seq<Delegate>)delegates, (Option<Set<Refined<String, Id.IdConstraint>>>)request.ids().map((Function1 & Serializable)x$3 -> x$3.value().map((Function1 & Serializable)x$4 -> new Refined((Object)x$4.id())).toSet())));
    }

    private boolean isDelegatedRequest(MailboxSession mailboxSession) {
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxSession.getLoggedInUser()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Username value = (Username)some.value();
            return !value.equals((Object)mailboxSession.getUser());
        }
        throw new MatchError((Object)option);
    }

    @Inject
    public DelegateGetMethod(MetricFactory metricFactory, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator, DelegationStore delegationStore) {
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        this.delegationStore = delegationStore;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Delegate/get")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_DELEGATION())}));
        Statics.releaseFence();
    }
}

