/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.Serializable;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.MailboxCreationRequest;
import org.apache.james.jmap.mail.Rights;
import org.apache.james.jmap.mail.UnparsedMailboxId;
import org.apache.james.jmap.method.MailboxCreationParseException;
import play.api.libs.json.JsObject;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class MailboxCreationRequest$
implements Serializable {
    public static final MailboxCreationRequest$ MODULE$ = new MailboxCreationRequest$();
    private static final scala.collection.immutable.Set<String> serverSetProperty = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id", "sortOrder", "role", "totalEmails", "totalThreads", "unreadEmails", "unreadThreads", "myRights"}));
    private static final scala.collection.immutable.Set<String> assignableProperties = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "parentId", "isSubscribed", "rights"}));
    private static final scala.collection.immutable.Set<String> knownProperties = (scala.collection.immutable.Set)MODULE$.assignableProperties().$plus$plus(MODULE$.serverSetProperty());

    private scala.collection.immutable.Set<String> serverSetProperty() {
        return serverSetProperty;
    }

    private scala.collection.immutable.Set<String> assignableProperties() {
        return assignableProperties;
    }

    private scala.collection.immutable.Set<String> knownProperties() {
        return knownProperties;
    }

    public Either<MailboxCreationParseException, JsObject> validateProperties(JsObject jsObject) {
        Set specifiedServerSetProperties;
        Set unknownProperties;
        Tuple2 tuple2 = new Tuple2((Object)jsObject.keys().intersect(this.serverSetProperty()), (Object)jsObject.keys().diff(this.knownProperties()));
        if (tuple2 != null && (unknownProperties = (Set)tuple2._2()).nonEmpty()) {
            return package$.MODULE$.Left().apply((Object)new MailboxCreationParseException(SetError$.MODULE$.invalidArguments("Some unknown properties were specified", (Option<Properties>)new Some((Object)Properties$.MODULE$.toProperties((scala.collection.immutable.Set<String>)unknownProperties.toSet())))));
        }
        if (tuple2 != null && (specifiedServerSetProperties = (Set)tuple2._1()).nonEmpty()) {
            return package$.MODULE$.Left().apply((Object)new MailboxCreationParseException(SetError$.MODULE$.invalidArguments("Some server-set properties were specified", (Option<Properties>)new Some((Object)Properties$.MODULE$.toProperties((scala.collection.immutable.Set<String>)specifiedServerSetProperties.toSet())))));
        }
        return package$.MODULE$.Right().apply((Object)jsObject);
    }

    public MailboxCreationRequest apply(String name, Option<UnparsedMailboxId> parentId, Option<IsSubscribed> isSubscribed, Option<Rights> rights) {
        return new MailboxCreationRequest(name, parentId, isSubscribed, rights);
    }

    public Option<Tuple4<Refined<String, boolean.Not<collection.Empty>>, Option<UnparsedMailboxId>, Option<IsSubscribed>, Option<Rights>>> unapply(MailboxCreationRequest x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)new Refined((Object)x$0.name()), x$0.parentId(), x$0.isSubscribed(), x$0.rights()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MailboxCreationRequest$.class);
    }

    private MailboxCreationRequest$() {
    }
}

