/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.DefaultMailboxes;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultMailboxesProvisioner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMailboxesProvisioner.class);
    private final MailboxManager mailboxManager;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    public DefaultMailboxesProvisioner(MailboxManager mailboxManager, MetricFactory metricFactory) {
        this.mailboxManager = mailboxManager;
        this.metricFactory = metricFactory;
    }

    public Mono<Void> createMailboxesIfNeeded(MailboxSession session) {
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-mailboxes-provisioning", this.createDefaultMailboxes(session)));
    }

    private Mono<Void> createDefaultMailboxes(MailboxSession session) {
        return Flux.fromIterable((Iterable)DefaultMailboxes.DEFAULT_MAILBOXES).map(this.toMailboxPath(session)).filterWhen(mailboxPath -> this.mailboxDoesntExist((MailboxPath)mailboxPath, session), 16).concatMap(mailboxPath -> this.createMailbox((MailboxPath)mailboxPath, session)).then();
    }

    private Mono<Boolean> mailboxDoesntExist(MailboxPath mailboxPath, MailboxSession session) {
        return Mono.from((Publisher)this.mailboxManager.mailboxExists(mailboxPath, session)).map(FunctionalUtils.negate());
    }

    private Function<String, MailboxPath> toMailboxPath(MailboxSession session) {
        return mailbox -> MailboxPath.forUser((Username)session.getUser(), (String)mailbox);
    }

    private Mono<Void> createMailbox(MailboxPath mailboxPath, MailboxSession session) {
        return Mono.from((Publisher)this.mailboxManager.createMailboxReactive(mailboxPath, MailboxManager.CreateOption.CREATE_SUBSCRIPTION, session)).onErrorResume(MailboxExistsException.class, e -> {
            LOGGER.info("Mailbox {} have been created concurrently", (Object)mailboxPath);
            return Mono.empty();
        }).then();
    }
}

