/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.search.comparator;

import java.util.Comparator;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.SearchUtil;
import org.apache.james.mailbox.store.search.comparator.AbstractHeaderComparator;

public class HeaderMailboxComparator
extends AbstractHeaderComparator {
    public static final Comparator<MailboxMessage> FROM_COMPARATOR = new HeaderMailboxComparator("from");
    public static final Comparator<MailboxMessage> TO_COMPARATOR = new HeaderMailboxComparator("to");
    public static final Comparator<MailboxMessage> CC_COMPARATOR = new HeaderMailboxComparator("cc");
    private final String headerName;

    public HeaderMailboxComparator(String headerName) {
        this.headerName = headerName;
    }

    @Override
    public int compare(MailboxMessage o1, MailboxMessage o2) {
        String mailbox1 = SearchUtil.getMailboxAddress(this.getHeaderValue(this.headerName, o1));
        String mailbox2 = SearchUtil.getMailboxAddress(this.getHeaderValue(this.headerName, o2));
        return mailbox1.compareToIgnoreCase(mailbox2);
    }
}

