/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.oss.driver.api.core.type.DataTypes;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.sieve.cassandra.tables.CassandraSieveActiveTable;
import org.apache.james.sieve.cassandra.tables.CassandraSieveClusterQuotaTable;
import org.apache.james.sieve.cassandra.tables.CassandraSieveQuotaTable;
import org.apache.james.sieve.cassandra.tables.CassandraSieveSpaceTable;
import org.apache.james.sieve.cassandra.tables.CassandraSieveTable;

public interface CassandraSieveRepositoryModule {
    public static final CassandraModule MODULE = CassandraModule.builder().table("sieve").comment("Holds SIEVE scripts.").options(options -> options).statement(statement -> types -> statement.withPartitionKey(CassandraSieveTable.USER_NAME, DataTypes.TEXT).withClusteringColumn(CassandraSieveTable.SCRIPT_NAME, DataTypes.TEXT).withColumn(CassandraSieveTable.SCRIPT_CONTENT, DataTypes.TEXT).withColumn(CassandraSieveTable.IS_ACTIVE, DataTypes.BOOLEAN).withColumn(CassandraSieveTable.SIZE, DataTypes.BIGINT)).table("sieve_space").comment("Holds per user current space occupied by SIEVE scripts.").options(options -> options).statement(statement -> types -> statement.withPartitionKey(CassandraSieveSpaceTable.USER_NAME, DataTypes.TEXT).withColumn(CassandraSieveSpaceTable.SPACE_USED, DataTypes.COUNTER)).table("sieve_quota").comment("Holds per user size limitations for SIEVE script storage.").options(options -> options).statement(statement -> types -> statement.withPartitionKey(CassandraSieveQuotaTable.USER_NAME, DataTypes.TEXT).withColumn(CassandraSieveQuotaTable.QUOTA, DataTypes.BIGINT)).table("sieve_cluster_quota").comment("Holds default size limitations for SIEVE script storage.").options(options -> options).statement(statement -> types -> statement.withPartitionKey(CassandraSieveClusterQuotaTable.NAME, DataTypes.TEXT).withColumn(CassandraSieveClusterQuotaTable.VALUE, DataTypes.BIGINT)).table("sieve_active").comment("Denormalisation table. Allows per user direct active SIEVE script retrieval.").options(options -> options).statement(statement -> types -> statement.withPartitionKey(CassandraSieveActiveTable.USER_NAME, DataTypes.TEXT).withColumn(CassandraSieveActiveTable.SCRIPT_NAME, DataTypes.TEXT).withColumn(CassandraSieveActiveTable.DATE, DataTypes.TIMESTAMP)).build();
}

