/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.GetAnnotationRequest;
import org.apache.james.mailbox.model.MailboxAnnotationKey;

public class GetAnnotationCommandParser
extends AbstractImapCommandParser {
    private static final CharMatcher ENDOFLINE_PATTERN = CharMatcher.isNot((char)'\n').and(CharMatcher.isNot((char)'\r'));
    private static final String MAXSIZE = "MAXSIZE";
    private static final String DEPTH = "DEPTH";
    private static final boolean STOP_ON_PAREN = true;

    public GetAnnotationCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.GETANNOTATION_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader requestReader, Tag tag, ImapSession session) throws DecodingException {
        try {
            return this.buildAnnotationRequest(requestReader, tag);
        }
        catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, e.getMessage(), e);
        }
    }

    private ImapMessage buildAnnotationRequest(ImapRequestLineReader requestReader, Tag tag) throws DecodingException {
        GetAnnotationRequest.Builder builder = GetAnnotationRequest.builder().tag(tag);
        builder.mailboxName(requestReader.mailbox());
        this.consumeOptionsAndKeys(requestReader, builder);
        if (ENDOFLINE_PATTERN.matches(requestReader.nextNonSpaceChar())) {
            this.consumeKey(requestReader, builder);
        }
        return builder.build();
    }

    private void consumeOptionsAndKeys(ImapRequestLineReader requestReader, GetAnnotationRequest.Builder builder) throws DecodingException {
        block4: while (requestReader.nextNonSpaceChar() == '(') {
            requestReader.consumeChar('(');
            switch (requestReader.nextChar()) {
                case 'M': {
                    this.consumeMaxsizeOpt(requestReader, builder);
                    continue block4;
                }
                case 'D': {
                    this.consumeDepthOpt(requestReader, builder);
                    continue block4;
                }
            }
            this.consumeKeys(requestReader, builder);
        }
    }

    private void consumeDepthOpt(ImapRequestLineReader requestReader, GetAnnotationRequest.Builder builder) throws DecodingException {
        if (!requestReader.atom().equalsIgnoreCase(DEPTH)) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Wrong on, it should be DEPTH");
        }
        builder.depth(GetAnnotationRequest.Depth.fromString(requestReader.atom()));
        requestReader.consumeChar(')');
    }

    private void consumeMaxsizeOpt(ImapRequestLineReader requestReader, GetAnnotationRequest.Builder builder) throws DecodingException {
        if (!requestReader.atom().equalsIgnoreCase(MAXSIZE)) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Wrong on, it should be MAXSIZE");
        }
        builder.maxsize(Optional.of((int)requestReader.number(true)));
        requestReader.consumeChar(')');
    }

    private void consumeKey(ImapRequestLineReader requestReader, GetAnnotationRequest.Builder builder) throws DecodingException {
        builder.keys((Set<MailboxAnnotationKey>)ImmutableSet.of((Object)new MailboxAnnotationKey(requestReader.atom())));
        requestReader.eol();
    }

    private void consumeKeys(ImapRequestLineReader requestReader, GetAnnotationRequest.Builder builder) throws DecodingException {
        ImmutableSet.Builder keys = ImmutableSet.builder();
        do {
            keys.add((Object)new MailboxAnnotationKey(requestReader.atom()));
        } while (requestReader.nextWordChar() != ')');
        builder.keys((Set<MailboxAnnotationKey>)keys.build());
        requestReader.consumeChar(')');
        requestReader.eol();
    }
}

