/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jpa;

import java.util.stream.Stream;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.apache.james.backends.jpa.TransactionRunner;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.mailrepository.api.MailRepositoryUrlStore;
import org.apache.james.mailrepository.jpa.JPAUrl;

public class JPAMailRepositoryUrlStore
implements MailRepositoryUrlStore {
    private final TransactionRunner transactionRunner;

    @Inject
    public JPAMailRepositoryUrlStore(EntityManagerFactory entityManagerFactory) {
        this.transactionRunner = new TransactionRunner(entityManagerFactory);
    }

    public void add(MailRepositoryUrl url) {
        this.transactionRunner.run(entityManager -> entityManager.merge((Object)JPAUrl.from(url)));
    }

    public Stream<MailRepositoryUrl> listDistinct() {
        return (Stream)this.transactionRunner.runAndRetrieveResult(entityManager -> entityManager.createNamedQuery("listUrls", JPAUrl.class).getResultList().stream().map(JPAUrl::toMailRepositoryUrl));
    }

    public boolean contains(MailRepositoryUrl url) {
        return (Boolean)this.transactionRunner.runAndRetrieveResult(entityManager -> !entityManager.createNamedQuery("getUrl", JPAUrl.class).setParameter("value", (Object)url.asString()).getResultList().isEmpty());
    }
}

