/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.pushsubscription;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.DeviceClientId;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionId;
import org.apache.james.jmap.api.model.PushSubscriptionKeys;
import org.apache.james.jmap.api.model.PushSubscriptionServerURL;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.model.VerificationCode;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class CassandraPushSubscriptionDAO {
    private final TypeStateFactory typeStateFactory;
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insert;
    private final PreparedStatement selectAll;
    private final PreparedStatement deleteOne;

    @Inject
    public CassandraPushSubscriptionDAO(Session session, TypeStateFactory typeStateFactory) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insert = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"push_subscription").value("user", (Object)QueryBuilder.bindMarker((String)"user")).value("device_client_id", (Object)QueryBuilder.bindMarker((String)"device_client_id")).value("id", (Object)QueryBuilder.bindMarker((String)"id")).value("expires", (Object)QueryBuilder.bindMarker((String)"expires")).value("types", (Object)QueryBuilder.bindMarker((String)"types")).value("url", (Object)QueryBuilder.bindMarker((String)"url")).value("verification_code", (Object)QueryBuilder.bindMarker((String)"verification_code")).value("encrypt_public_key", (Object)QueryBuilder.bindMarker((String)"encrypt_public_key")).value("encrypt_auth_secret", (Object)QueryBuilder.bindMarker((String)"encrypt_auth_secret")).value("validated", (Object)QueryBuilder.bindMarker((String)"validated")));
        this.selectAll = session.prepare((RegularStatement)QueryBuilder.select().from("push_subscription").where(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))));
        this.deleteOne = session.prepare((RegularStatement)QueryBuilder.delete().from("push_subscription").where(QueryBuilder.eq((String)"user", (Object)QueryBuilder.bindMarker((String)"user"))).and(QueryBuilder.eq((String)"device_client_id", (Object)QueryBuilder.bindMarker((String)"device_client_id"))));
        this.typeStateFactory = typeStateFactory;
    }

    public Mono<PushSubscription> insert(Username username, PushSubscription subscription) {
        java.util.Set typeNames = CollectionConverters.asJava((Set)((Iterable)subscription.types().map(TypeName::asString)).toSet());
        Instant utcInstant = subscription.expires().value().withZoneSameInstant(ZoneOffset.UTC).toInstant();
        BoundStatement insertSubscription = this.insert.bind().setString("user", username.asString()).setString("device_client_id", subscription.deviceClientId()).setUUID("id", subscription.id().value()).setTimestamp("expires", Date.from(utcInstant)).setSet("types", typeNames).setString("url", subscription.url().value().toString()).setString("verification_code", subscription.verificationCode()).setBool("validated", subscription.validated());
        OptionConverters.toJava((Option)subscription.keys()).ifPresent(keys -> insertSubscription.setString("encrypt_public_key", keys.p256dh()).setString("encrypt_auth_secret", keys.auth()));
        return this.executor.executeVoid((Statement)insertSubscription).thenReturn((Object)subscription);
    }

    public Flux<PushSubscription> selectAll(Username username) {
        return this.executor.executeRows((Statement)this.selectAll.bind().setString("user", username.asString())).map(this::toPushSubscription);
    }

    public Mono<Void> deleteOne(Username username, String deviceClientId) {
        return this.executor.executeVoid((Statement)this.deleteOne.bind().setString("user", username.asString()).setString("device_client_id", deviceClientId));
    }

    private PushSubscription toPushSubscription(Row row) {
        return PushSubscription.apply((PushSubscriptionId)PushSubscriptionId.apply((UUID)row.getUUID("id")), (String)DeviceClientId.apply((String)row.getString("device_client_id")), (PushSubscriptionServerURL)((PushSubscriptionServerURL)PushSubscriptionServerURL.from((String)row.getString("url")).get()), this.toKeys(row), (String)VerificationCode.apply((String)row.getString("verification_code")), (boolean)row.getBool("validated"), (PushSubscriptionExpiredTime)this.toExpires(row), this.toTypes(row));
    }

    private Option<PushSubscriptionKeys> toKeys(Row row) {
        String p256dh = row.getString("encrypt_public_key");
        String auth = row.getString("encrypt_auth_secret");
        if (p256dh == null && auth == null) {
            return Option.empty();
        }
        return Option.apply((Object)PushSubscriptionKeys.apply((String)p256dh, (String)auth));
    }

    private PushSubscriptionExpiredTime toExpires(Row row) {
        return PushSubscriptionExpiredTime.apply((ZonedDateTime)ZonedDateTime.ofInstant(row.getTimestamp("expires").toInstant(), ZoneOffset.UTC));
    }

    private Seq<TypeName> toTypes(Row row) {
        return CollectionConverters.asScala((java.util.Set)((java.util.Set)row.getSet("types", String.class).stream().map(string -> (TypeName)this.typeStateFactory.parse(string).right().get()).collect(ImmutableSet.toImmutableSet()))).toSeq();
    }
}

