/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data.db;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.db.DbDataStore;
import org.apache.jackrabbit.core.util.db.DbUtility;

public class DbInputStream
extends AutoCloseInputStream {
    protected DbDataStore store;
    protected DataIdentifier identifier;
    protected boolean endOfStream;
    protected ResultSet rs;
    private InputStream initialStream;

    protected DbInputStream(DbDataStore store, DataIdentifier identifier) {
        super(null);
        this.store = store;
        this.identifier = identifier;
        this.initialStream = this.in;
    }

    protected void openStream() throws IOException {
        if (this.endOfStream) {
            throw new EOFException();
        }
        if (this.in == this.initialStream) {
            try {
                this.in = this.store.openStream(this, this.identifier);
            }
            catch (DataStoreException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        this.openStream();
        int c = this.in.read();
        if (c == -1) {
            this.endOfStream = true;
            this.close();
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        this.openStream();
        int c = this.in.read(b, off, len);
        if (c == -1) {
            this.endOfStream = true;
            this.close();
        }
        return c;
    }

    @Override
    public void close() throws IOException {
        if (this.in != this.initialStream) {
            this.in.close();
            this.in = this.initialStream;
            if (this.rs != null) {
                DbUtility.close(this.rs);
                this.rs = null;
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.endOfStream) {
            return -1L;
        }
        this.openStream();
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.endOfStream) {
            return 0;
        }
        this.openStream();
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    void setResultSet(ResultSet rs) {
        this.rs = rs;
    }
}

