/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.write.TsFileWriter;
import org.apache.tsfile.write.record.TSRecord;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.tsfile.write.record.datapoint.DataPoint;
import org.apache.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.tsfile.write.record.datapoint.StringDataPoint;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class TsFileGeneratorUtils {
    private static final FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    public static final String testStorageGroup = "root.testsg";
    public static int alignDeviceOffset = 10000;
    public static boolean useMultiType = false;

    public static void writeWithTsRecord(TsFileWriter tsFileWriter, String deviceId, List<IMeasurementSchema> schemas, long rowSize, long startTime, long startValue, boolean isAligned) throws IOException, WriteProcessException {
        long time = startTime;
        while (time < rowSize + startTime) {
            TSRecord tsRecord = new TSRecord(deviceId, time);
            for (IMeasurementSchema schema : schemas) {
                DataPoint dPoint;
                switch (schema.getType()) {
                    case INT64: 
                    case TIMESTAMP: {
                        dPoint = new LongDataPoint(schema.getMeasurementName(), startValue);
                        break;
                    }
                    case INT32: 
                    case DATE: {
                        dPoint = new IntDataPoint(schema.getMeasurementName(), (int)startValue);
                        break;
                    }
                    case DOUBLE: {
                        dPoint = new DoubleDataPoint(schema.getMeasurementName(), startValue);
                        break;
                    }
                    case FLOAT: {
                        dPoint = new FloatDataPoint(schema.getMeasurementName(), startValue);
                        break;
                    }
                    case BOOLEAN: {
                        dPoint = new BooleanDataPoint(schema.getMeasurementName(), true);
                        break;
                    }
                    default: {
                        dPoint = new StringDataPoint(schema.getMeasurementName(), new Binary(String.valueOf(startValue), TSFileConfig.STRING_CHARSET));
                    }
                }
                tsRecord.addTuple(dPoint);
            }
            if (isAligned) {
                tsFileWriter.writeRecord(tsRecord);
            } else {
                tsFileWriter.writeRecord(tsRecord);
            }
            ++time;
            ++startValue;
        }
    }

    public static void writeWithTablet(TsFileWriter tsFileWriter, String deviceId, List<IMeasurementSchema> schemas, long rowNum, long startTime, long startValue, boolean isAligned) throws IOException, WriteProcessException {
        Tablet tablet = new Tablet(deviceId, schemas);
        long sensorNum = schemas.size();
        long r = 0L;
        while (r < rowNum) {
            int row = tablet.getRowSize();
            tablet.addTimestamp(row, startTime++);
            int i = 0;
            while ((long)i < sensorNum) {
                tablet.addValue(row, i, startValue);
                ++i;
            }
            if (tablet.getRowSize() == tablet.getMaxRowNumber()) {
                if (isAligned) {
                    tsFileWriter.writeAligned(tablet);
                } else {
                    tsFileWriter.writeTree(tablet);
                }
                tablet.reset();
            }
            ++r;
            ++startValue;
        }
        if (tablet.getRowSize() != 0) {
            if (isAligned) {
                tsFileWriter.writeAligned(tablet);
            } else {
                tsFileWriter.writeTree(tablet);
            }
            tablet.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generateMixTsFile(String filePath, int deviceNum, int measurementNum, int pointNum, int startTime, int startValue, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        int originGroupSize = TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte();
        int originPageSize = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        try {
            if (chunkGroupSize > 0) {
                TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
            }
            if (pageSize > 0) {
                TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
            }
            try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
                int i;
                int i2;
                ArrayList<IMeasurementSchema> alignedMeasurementSchemas = new ArrayList<IMeasurementSchema>();
                for (i2 = 0; i2 < measurementNum; ++i2) {
                    alignedMeasurementSchemas.add(new MeasurementSchema("s" + i2, TSDataType.INT64, TSEncoding.PLAIN));
                }
                for (i2 = alignDeviceOffset; i2 < alignDeviceOffset + deviceNum; ++i2) {
                    tsFileWriter.registerAlignedTimeseries(new Path("root.testsg.d" + i2), alignedMeasurementSchemas);
                }
                for (i2 = alignDeviceOffset; i2 < alignDeviceOffset + deviceNum; ++i2) {
                    TsFileGeneratorUtils.writeWithTsRecord(tsFileWriter, "root.testsg.d" + i2, alignedMeasurementSchemas, pointNum, startTime, startValue, true);
                }
                ArrayList<IMeasurementSchema> measurementSchemas = new ArrayList<IMeasurementSchema>();
                for (i = 0; i < measurementNum; ++i) {
                    measurementSchemas.add(new MeasurementSchema("s" + i, TSDataType.INT64, TSEncoding.PLAIN));
                }
                for (i = 0; i < deviceNum; ++i) {
                    tsFileWriter.registerTimeseries(new Path("root.testsg.d" + i), measurementSchemas);
                }
                for (i = 0; i < deviceNum; ++i) {
                    TsFileGeneratorUtils.writeWithTsRecord(tsFileWriter, "root.testsg.d" + i, measurementSchemas, pointNum, startTime, startValue, false);
                }
            }
            File file2 = file;
            return file2;
        }
        finally {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(originGroupSize);
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(originPageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generateAlignedTsFile(String filePath, int deviceNum, int measurementNum, int pointNum, long startTime, int startValue, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        int originGroupSize = TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte();
        int originPageSize = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        if (chunkGroupSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
        }
        if (pageSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
        }
        try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
            int i;
            ArrayList<IMeasurementSchema> alignedMeasurementSchemas = new ArrayList<IMeasurementSchema>();
            for (i = 0; i < measurementNum; ++i) {
                alignedMeasurementSchemas.add(new MeasurementSchema("s" + i, TsFileGeneratorUtils.getDataType(i), TSEncoding.PLAIN));
            }
            for (i = alignDeviceOffset; i < alignDeviceOffset + deviceNum; ++i) {
                tsFileWriter.registerAlignedTimeseries(new Path("root.testsg.d" + i), alignedMeasurementSchemas);
            }
            for (i = alignDeviceOffset; i < alignDeviceOffset + deviceNum; ++i) {
                TsFileGeneratorUtils.writeWithTsRecord(tsFileWriter, "root.testsg.d" + i, alignedMeasurementSchemas, pointNum, startTime, startValue, true);
            }
        }
        finally {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(originGroupSize);
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(originPageSize);
        }
        return file;
    }

    public static File generateNonAlignedTsFile(String filePath, int deviceNum, int measurementNum, int pointNum, long startTime, int startValue, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        int originGroupSize = TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte();
        int originPageSize = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        if (chunkGroupSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
        }
        if (pageSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
        }
        try {
            File file2;
            try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
                int i;
                ArrayList<IMeasurementSchema> measurementSchemas = new ArrayList<IMeasurementSchema>();
                for (i = 0; i < measurementNum; ++i) {
                    measurementSchemas.add(new MeasurementSchema("s" + i, TsFileGeneratorUtils.getDataType(i), TSEncoding.PLAIN));
                }
                for (i = 0; i < deviceNum; ++i) {
                    tsFileWriter.registerTimeseries(new Path("root.testsg.d" + i), measurementSchemas);
                }
                for (i = 0; i < deviceNum; ++i) {
                    TsFileGeneratorUtils.writeWithTsRecord(tsFileWriter, "root.testsg.d" + i, measurementSchemas, pointNum, startTime, startValue, false);
                }
                file2 = file;
            }
            return file2;
        }
        finally {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(originGroupSize);
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(originPageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generateAlignedTsFileWithTextValues(String filePath, List<Integer> deviceIndex, List<Integer> measurementIndex, int pointNum, int startTime, String value, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        int originGroupSize = TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte();
        int originPageSize = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        if (chunkGroupSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
        }
        if (pageSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
        }
        try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
            int i;
            ArrayList<IMeasurementSchema> alignedMeasurementSchemas = new ArrayList<IMeasurementSchema>();
            for (i = 0; i < measurementIndex.size(); ++i) {
                alignedMeasurementSchemas.add(new MeasurementSchema("s" + measurementIndex.get(i), TSDataType.TEXT, TSEncoding.PLAIN));
            }
            for (i = 0; i < deviceIndex.size(); ++i) {
                tsFileWriter.registerAlignedTimeseries(new Path("root.testsg.d" + (deviceIndex.get(i) + alignDeviceOffset)), alignedMeasurementSchemas);
            }
            for (i = 0; i < deviceIndex.size(); ++i) {
                for (long time = (long)startTime; time < (long)(pointNum + startTime); ++time) {
                    TSRecord tsRecord = new TSRecord("root.testsg.d" + (deviceIndex.get(i) + alignDeviceOffset), time);
                    for (IMeasurementSchema schema : alignedMeasurementSchemas) {
                        StringDataPoint dPoint = new StringDataPoint(schema.getMeasurementName(), new Binary(value, TSFileConfig.STRING_CHARSET));
                        tsRecord.addTuple(dPoint);
                    }
                    tsFileWriter.writeRecord(tsRecord);
                }
            }
        }
        finally {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(originGroupSize);
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(originPageSize);
        }
        return file;
    }

    public static File generateNonAlignedTsFileWithTextValues(String filePath, List<Integer> deviceIndex, List<Integer> measurementIndex, int pointNum, int startTime, String value, int chunkGroupSize, int pageSize) throws IOException, WriteProcessException {
        File file = fsFactory.getFile(filePath);
        if (file.exists()) {
            file.delete();
        }
        int originGroupSize = TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte();
        int originPageSize = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        if (chunkGroupSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(chunkGroupSize);
        }
        if (pageSize > 0) {
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(pageSize);
        }
        try {
            File file2;
            try (TsFileWriter tsFileWriter = new TsFileWriter(file);){
                int i;
                ArrayList<IMeasurementSchema> measurementSchemas = new ArrayList<IMeasurementSchema>();
                for (i = 0; i < measurementIndex.size(); ++i) {
                    measurementSchemas.add(new MeasurementSchema("s" + measurementIndex.get(i), TSDataType.TEXT, TSEncoding.PLAIN));
                }
                for (i = 0; i < deviceIndex.size(); ++i) {
                    tsFileWriter.registerTimeseries(new Path("root.testsg.d" + deviceIndex.get(i)), measurementSchemas);
                }
                for (i = 0; i < deviceIndex.size(); ++i) {
                    for (long time = (long)startTime; time < (long)(pointNum + startTime); ++time) {
                        TSRecord tsRecord = new TSRecord("root.testsg.d" + deviceIndex.get(i), time);
                        for (IMeasurementSchema schema : measurementSchemas) {
                            StringDataPoint dPoint = new StringDataPoint(schema.getMeasurementName(), new Binary(value, TSFileConfig.STRING_CHARSET));
                            tsRecord.addTuple(dPoint);
                        }
                        tsFileWriter.writeRecord(tsRecord);
                    }
                }
                file2 = file;
            }
            return file2;
        }
        finally {
            TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(originGroupSize);
            TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(originPageSize);
        }
    }

    public static TSDataType getDataType(int num) {
        if (!useMultiType) {
            return TSDataType.INT64;
        }
        switch (num % 6) {
            case 0: {
                return TSDataType.BOOLEAN;
            }
            case 1: {
                return TSDataType.INT32;
            }
            case 2: {
                return TSDataType.INT64;
            }
            case 3: {
                return TSDataType.FLOAT;
            }
            case 4: {
                return TSDataType.DOUBLE;
            }
            case 5: {
                return TSDataType.TEXT;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + num % 6);
    }

    public static String getTsFilePath(String fileParentPath, long tsFileVersion) {
        String fileName = System.currentTimeMillis() + "-" + tsFileVersion + "-0-0.tsfile";
        return fileParentPath.concat(fileName);
    }

    public static int getAlignDeviceOffset() {
        return alignDeviceOffset;
    }
}

