/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.ISubscriptionsRepository;
import io.moquette.broker.Utils;
import io.moquette.broker.subscriptions.ShareName;
import io.moquette.broker.subscriptions.SharedSubscription;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.SubscriptionIdentifier;
import io.moquette.broker.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemorySubscriptionsRepository
implements ISubscriptionsRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MemorySubscriptionsRepository.class);
    private final Set<Subscription> subscriptions = new ConcurrentSkipListSet<Subscription>();
    private final Map<String, Map<Utils.Couple<ShareName, Topic>, SharedSubscription>> sharedSubscriptions = new HashMap<String, Map<Utils.Couple<ShareName, Topic>, SharedSubscription>>();

    @Override
    public Set<Subscription> listAllSubscriptions() {
        return Collections.unmodifiableSet(this.subscriptions);
    }

    @Override
    public void addNewSubscription(Subscription subscription) {
        this.subscriptions.add(subscription);
    }

    @Override
    public void removeSubscription(String topic, String clientID) {
        this.subscriptions.stream().filter(s -> s.getTopicFilter().toString().equals(topic) && s.getClientId().equals(clientID)).findFirst().ifPresent(this.subscriptions::remove);
    }

    @Override
    public void removeAllSharedSubscriptions(String clientId) {
        this.sharedSubscriptions.remove(clientId);
    }

    @Override
    public void removeSharedSubscription(String clientId, ShareName share, Topic topicFilter) {
        Map<Utils.Couple<ShareName, Topic>, SharedSubscription> subsMap = this.sharedSubscriptions.get(clientId);
        if (subsMap == null) {
            LOG.info("Removing a non existing shared subscription for client: {}", (Object)clientId);
            return;
        }
        subsMap.remove(Utils.Couple.of(share, topicFilter));
        if (subsMap.isEmpty()) {
            this.sharedSubscriptions.remove(clientId);
        }
    }

    @Override
    public void addNewSharedSubscription(String clientId, ShareName share, Topic topicFilter, MqttSubscriptionOption option) {
        SharedSubscription sharedSub = new SharedSubscription(share, topicFilter, clientId, option);
        this.storeNewSharedSubscription(clientId, share, topicFilter, sharedSub);
    }

    private void storeNewSharedSubscription(String clientId, ShareName share, Topic topicFilter, SharedSubscription sharedSub) {
        Map subsMap = this.sharedSubscriptions.computeIfAbsent(clientId, unused -> new HashMap());
        subsMap.put(Utils.Couple.of(share, topicFilter), sharedSub);
    }

    @Override
    public void addNewSharedSubscription(String clientId, ShareName share, Topic topicFilter, MqttSubscriptionOption option, SubscriptionIdentifier subscriptionIdentifier) {
        SharedSubscription sharedSub = new SharedSubscription(share, topicFilter, clientId, option, subscriptionIdentifier);
        this.storeNewSharedSubscription(clientId, share, topicFilter, sharedSub);
    }

    @Override
    public Collection<SharedSubscription> listAllSharedSubscription() {
        ArrayList<SharedSubscription> result = new ArrayList<SharedSubscription>();
        for (Map.Entry<String, Map<Utils.Couple<ShareName, Topic>, SharedSubscription>> entry : this.sharedSubscriptions.entrySet()) {
            for (Map.Entry<Utils.Couple<ShareName, Topic>, SharedSubscription> nestedEntry : entry.getValue().entrySet()) {
                result.add(nestedEntry.getValue());
            }
        }
        return result;
    }
}

