/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.node;

import java.util.List;
import org.apache.iotdb.consensus.iot.log.ConsensusReqReader;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.ContinuousSameSearchIndexSeparatorNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalDeleteDataNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALException;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;

public class WALFakeNode
implements IWALNode {
    private final AbstractResultListener.Status status;
    private final WALFlushListener successListener;
    private final WALFlushListener failListener;

    private WALFakeNode(AbstractResultListener.Status status) {
        this(status, (Exception)null);
    }

    public WALFakeNode(AbstractResultListener.Status status, Exception cause) {
        this.status = status;
        this.successListener = new WALFlushListener(false);
        this.successListener.succeed();
        this.failListener = new WALFlushListener(false);
        this.failListener.fail(cause);
    }

    @Override
    public WALFlushListener log(long memTableId, InsertRowNode insertRowNode) {
        return this.getResult();
    }

    @Override
    public WALFlushListener log(long memTableId, InsertRowsNode insertRowsNode) {
        return this.getResult();
    }

    @Override
    public WALFlushListener log(long memTableId, InsertTabletNode insertTabletNode, List<int[]> rangeList) {
        return this.getResult();
    }

    @Override
    public WALFlushListener log(long memTableId, DeleteDataNode deleteDataNode) {
        return this.getResult();
    }

    @Override
    public WALFlushListener log(long memTableId, RelationalDeleteDataNode deleteDataNode) {
        return this.getResult();
    }

    @Override
    public WALFlushListener log(long memTableId, ContinuousSameSearchIndexSeparatorNode separatorNode) {
        return this.getResult();
    }

    private WALFlushListener getResult() {
        switch (this.status) {
            case SUCCESS: {
                return this.successListener;
            }
        }
        return this.failListener;
    }

    @Override
    public void onMemTableFlushStarted(IMemTable memTable) {
    }

    @Override
    public void onMemTableFlushed(IMemTable memTable) {
    }

    @Override
    public void onMemTableCreated(IMemTable memTable, String targetTsFile) {
    }

    public void setSafelyDeletedSearchIndex(long safelyDeletedSearchIndex) {
        throw new UnsupportedOperationException();
    }

    public ConsensusReqReader.ReqIterator getReqIterator(long startIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    public long getCurrentSearchIndex() {
        return 0L;
    }

    public long getCurrentWALFileVersion() {
        return 0L;
    }

    public long getTotalSize() {
        return 0L;
    }

    public static WALFakeNode getFailureInstance(Exception e) {
        return new WALFakeNode(AbstractResultListener.Status.FAILURE, (Exception)((Object)new WALException("Cannot write wal into a fake node. ", e)));
    }

    public static WALFakeNode getSuccessInstance() {
        return WALFakeNodeHolder.SUCCESS_INSTANCE;
    }

    private static class WALFakeNodeHolder {
        private static final WALFakeNode SUCCESS_INSTANCE = new WALFakeNode(AbstractResultListener.Status.SUCCESS);

        private WALFakeNodeHolder() {
        }
    }
}

