/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TwoChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;

public class CorrelatedJoinNode
extends TwoChildProcessNode {
    private final List<Symbol> correlation;
    private final JoinNode.JoinType type;
    private final Expression filter;
    private final Node originSubquery;

    public CorrelatedJoinNode(PlanNodeId id, PlanNode input, PlanNode subquery, List<Symbol> correlation, JoinNode.JoinType type, Expression filter, Node originSubquery) {
        super(id, input, subquery);
        Objects.requireNonNull(correlation, "correlation is null");
        Objects.requireNonNull(filter, "filter is null");
        Preconditions.checkArgument((!(filter instanceof NullLiteral) ? 1 : 0) != 0, (String)"Filter must be an expression of boolean type: %s", (Object)filter);
        Objects.requireNonNull(originSubquery, "originSubquery is null");
        if (input != null) {
            Preconditions.checkArgument((boolean)input.getOutputSymbols().containsAll(correlation), (Object)"Input does not contain symbols from correlation");
        }
        this.correlation = ImmutableList.copyOf(correlation);
        this.type = type;
        this.filter = filter;
        this.originSubquery = originSubquery;
    }

    public PlanNode getInput() {
        return this.leftChild;
    }

    public PlanNode getSubquery() {
        return this.rightChild;
    }

    public List<Symbol> getCorrelation() {
        return this.correlation;
    }

    public JoinNode.JoinType getJoinType() {
        return this.type;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public Node getOriginSubquery() {
        return this.originSubquery;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.leftChild, (Object)this.rightChild);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.leftChild.getOutputSymbols()).addAll(this.rightChild.getOutputSymbols()).build();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new CorrelatedJoinNode(this.getPlanNodeId(), newChildren.get(0), newChildren.get(1), this.correlation, this.type, this.filter, this.originSubquery);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitCorrelatedJoin(this, context);
    }

    @Override
    public PlanNode clone() {
        return new CorrelatedJoinNode(this.getPlanNodeId(), null, null, this.correlation, this.type, this.filter, this.originSubquery);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }
}

