/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestType;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.request.PipeConsensusRequestVersion;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.tsfile.utils.PublicBAOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusTabletInsertNodeReq
extends TPipeConsensusTransferReq {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusTabletInsertNodeReq.class);
    private transient InsertNode insertNode;

    private PipeConsensusTabletInsertNodeReq() {
    }

    public InsertNode getInsertNode() {
        return this.insertNode;
    }

    public static PipeConsensusTabletInsertNodeReq toTPipeConsensusTransferRawReq(InsertNode insertNode, TCommitId commitId, TConsensusGroupId consensusGroupId, ProgressIndex progressIndex, int thisDataNodeId) {
        PipeConsensusTabletInsertNodeReq req = new PipeConsensusTabletInsertNodeReq();
        req.insertNode = insertNode;
        req.commitId = commitId;
        req.consensusGroupId = consensusGroupId;
        req.dataNodeId = thisDataNodeId;
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            progressIndex.serialize((OutputStream)outputStream);
            req.progressIndex = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to serialize progress index {}", (Object)progressIndex, (Object)e);
        }
        return req;
    }

    public static PipeConsensusTabletInsertNodeReq toTPipeConsensusTransferReq(InsertNode insertNode, TCommitId commitId, TConsensusGroupId consensusGroupId, ProgressIndex progressIndex, int thisDataNodeId) {
        PipeConsensusTabletInsertNodeReq req = new PipeConsensusTabletInsertNodeReq();
        req.insertNode = insertNode;
        req.commitId = commitId;
        req.consensusGroupId = consensusGroupId;
        req.dataNodeId = thisDataNodeId;
        req.version = PipeConsensusRequestVersion.VERSION_1.getVersion();
        req.type = PipeConsensusRequestType.TRANSFER_TABLET_INSERT_NODE.getType();
        req.body = insertNode.serializeToByteBuffer();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            progressIndex.serialize((OutputStream)outputStream);
            req.progressIndex = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to serialize progress index {}", (Object)progressIndex, (Object)e);
        }
        return req;
    }

    public static PipeConsensusTabletInsertNodeReq fromTPipeConsensusTransferReq(TPipeConsensusTransferReq transferReq) {
        PipeConsensusTabletInsertNodeReq insertNodeReq = new PipeConsensusTabletInsertNodeReq();
        insertNodeReq.insertNode = (InsertNode)PlanNodeType.deserialize(transferReq.body);
        insertNodeReq.version = transferReq.version;
        insertNodeReq.type = transferReq.type;
        insertNodeReq.body = transferReq.body;
        insertNodeReq.commitId = transferReq.commitId;
        insertNodeReq.dataNodeId = transferReq.dataNodeId;
        insertNodeReq.consensusGroupId = transferReq.consensusGroupId;
        insertNodeReq.progressIndex = transferReq.progressIndex;
        return insertNodeReq;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeConsensusTabletInsertNodeReq that = (PipeConsensusTabletInsertNodeReq)((Object)obj);
        return Objects.equals(this.insertNode, that.insertNode) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body) && Objects.equals(this.commitId, that.commitId) && Objects.equals(this.consensusGroupId, that.consensusGroupId) && Objects.equals(this.progressIndex, that.progressIndex) && Objects.equals(this.dataNodeId, that.dataNodeId);
    }

    public int hashCode() {
        return Objects.hash(this.insertNode, this.version, this.type, this.body, this.commitId, this.consensusGroupId, this.dataNodeId, this.progressIndex);
    }
}

