/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BooleanColumn;
import org.apache.tsfile.read.common.block.column.ColumnEncoder;

public class ByteArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        if (!TSDataType.BOOLEAN.equals((Object)dataType)) {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        boolean[] values = ColumnEncoder.deserializeBooleanArray(input, positionCount);
        return new BooleanColumn(0, positionCount, nullIndicators, values);
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        if (!TSDataType.BOOLEAN.equals((Object)dataType)) {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
        ColumnEncoder.serializeBooleanArray(output, column, Column::getBoolean);
    }
}

