/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.utils.datastructure.BatchEncodeInfo;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.read.reader.series.PaginationController;
import org.apache.tsfile.write.chunk.IChunkWriter;

public abstract class MemPointIterator
implements IPointReader {
    protected final Ordering scanOrder;
    protected Filter pushDownFilter;
    protected PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;
    protected TimeRange timeRange;
    protected List<TsBlock> tsBlocks;
    protected boolean streamingQueryMemChunk = true;

    public MemPointIterator(Ordering scanOrder) {
        this.scanOrder = scanOrder;
    }

    public abstract TsBlock getBatch(int var1);

    public abstract boolean hasNextBatch();

    public abstract TsBlock nextBatch();

    public abstract void encodeBatch(IChunkWriter var1, BatchEncodeInfo var2, long[] var3);

    public void setPushDownFilter(Filter pushDownFilter) {
        this.pushDownFilter = pushDownFilter;
    }

    public void setLimitAndOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    public void setCurrentPageTimeRange(TimeRange timeRange) {
        this.timeRange = timeRange;
        this.skipToCurrentTimeRangeStartPosition();
    }

    protected void skipToCurrentTimeRangeStartPosition() {
    }

    protected boolean isCurrentTimeExceedTimeRange(long time) {
        return this.timeRange != null && (this.scanOrder.isAscending() ? time > this.timeRange.getMax() : time < this.timeRange.getMin());
    }

    public void setStreamingQueryMemChunk(boolean streamingQueryMemChunk) {
        this.streamingQueryMemChunk = streamingQueryMemChunk;
    }

    protected void addTsBlock(TsBlock tsBlock) {
        if (this.streamingQueryMemChunk) {
            return;
        }
        this.tsBlocks = this.tsBlocks == null ? new ArrayList() : this.tsBlocks;
        this.tsBlocks.add(tsBlock);
    }

    public void close() throws IOException {
        if (this.tsBlocks != null) {
            this.tsBlocks.clear();
        }
    }
}

