/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.AggregationStep;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AggregationDescriptor {
    protected final TAggregationType aggregationType;
    protected final String aggregationFuncName;
    protected AggregationStep step;
    protected List<Expression> inputExpressions;
    protected final Map<String, String> inputAttributes;
    protected String parametersString;

    public AggregationDescriptor(String aggregationFuncName, AggregationStep step, List<Expression> inputExpressions, Map<String, String> inputAttributes) {
        this.aggregationFuncName = aggregationFuncName;
        this.aggregationType = AggregationDescriptor.getAggregationTypeByFuncName(aggregationFuncName);
        this.step = step;
        this.inputExpressions = inputExpressions;
        this.inputAttributes = inputAttributes;
    }

    public static TAggregationType getAggregationTypeByFuncName(String funcName) {
        if (AggregationUtil.isBuiltinAggregationName(funcName.toLowerCase())) {
            return TAggregationType.valueOf((String)funcName.toUpperCase());
        }
        return TAggregationType.UDAF;
    }

    @Deprecated
    public AggregationDescriptor(String aggregationFuncName, AggregationStep step, List<Expression> inputExpressions) {
        this.aggregationFuncName = aggregationFuncName;
        this.aggregationType = TAggregationType.valueOf((String)aggregationFuncName.toUpperCase());
        this.step = step;
        this.inputExpressions = inputExpressions;
        this.inputAttributes = Collections.emptyMap();
    }

    public AggregationDescriptor(AggregationDescriptor other) {
        this.aggregationFuncName = other.aggregationFuncName;
        this.aggregationType = other.getAggregationType();
        this.step = other.getStep();
        this.inputExpressions = other.getInputExpressions();
        this.inputAttributes = other.inputAttributes;
    }

    public String getAggregationFuncName() {
        return this.aggregationFuncName;
    }

    public List<String> getOutputColumnNames() {
        List<String> outputAggregationNames = this.getActualAggregationNames(this.step.isOutputPartial());
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (String funcName : outputAggregationNames) {
            outputColumnNames.add(funcName + "(" + this.getParametersString() + ")");
        }
        return outputColumnNames;
    }

    public List<List<String>> getInputColumnNamesList() {
        if (this.step.isInputRaw()) {
            List<String> inputColumnNames = "count_if".equalsIgnoreCase(this.aggregationFuncName) ? Collections.singletonList(this.inputExpressions.get(0).getExpressionString()) : this.inputExpressions.stream().map(Expression::getExpressionString).collect(Collectors.toList());
            return Collections.singletonList(inputColumnNames);
        }
        return Collections.singletonList(this.getInputColumnNames());
    }

    public List<String> getInputColumnNames() {
        List<String> inputAggregationNames = this.getActualAggregationNames(this.step.isInputPartial());
        ArrayList<String> inputColumnNames = new ArrayList<String>();
        for (String funcName : inputAggregationNames) {
            inputColumnNames.add(funcName + "(" + this.getParametersString() + ")");
        }
        return inputColumnNames;
    }

    public List<String> getActualAggregationNames(boolean isPartial) {
        ArrayList<String> outputAggregationNames = new ArrayList<String>();
        if (isPartial) {
            switch (this.aggregationType) {
                case AVG: {
                    outputAggregationNames.add("count");
                    outputAggregationNames.add("sum");
                    break;
                }
                case FIRST_VALUE: {
                    outputAggregationNames.add("first_value");
                    outputAggregationNames.add("min_time");
                    break;
                }
                case LAST_VALUE: {
                    outputAggregationNames.add("last_value");
                    outputAggregationNames.add("max_time");
                    break;
                }
                case TIME_DURATION: {
                    outputAggregationNames.add("max_time");
                    outputAggregationNames.add("min_time");
                    break;
                }
                case STDDEV: {
                    outputAggregationNames.add(AggregationUtil.addPartialSuffix("stddev"));
                    break;
                }
                case STDDEV_POP: {
                    outputAggregationNames.add(AggregationUtil.addPartialSuffix("stddev_pop"));
                    break;
                }
                case STDDEV_SAMP: {
                    outputAggregationNames.add(AggregationUtil.addPartialSuffix("stddev_samp"));
                    break;
                }
                case VARIANCE: {
                    outputAggregationNames.add(AggregationUtil.addPartialSuffix("variance"));
                    break;
                }
                case VAR_POP: {
                    outputAggregationNames.add(AggregationUtil.addPartialSuffix("var_pop"));
                    break;
                }
                case VAR_SAMP: {
                    outputAggregationNames.add(AggregationUtil.addPartialSuffix("var_samp"));
                    break;
                }
                case MAX_BY: {
                    outputAggregationNames.add(AggregationUtil.addPartialSuffix("max_by"));
                    break;
                }
                case MIN_BY: {
                    outputAggregationNames.add(AggregationUtil.addPartialSuffix("min_by"));
                    break;
                }
                case UDAF: {
                    outputAggregationNames.add(AggregationUtil.addPartialSuffix(this.aggregationFuncName));
                    break;
                }
                default: {
                    outputAggregationNames.add(this.aggregationFuncName);
                    break;
                }
            }
        } else {
            outputAggregationNames.add(this.aggregationFuncName);
        }
        return outputAggregationNames;
    }

    public String getParametersString() {
        if (this.parametersString == null) {
            StringBuilder builder = new StringBuilder();
            if (!this.inputExpressions.isEmpty()) {
                builder.append(this.inputExpressions.get(0).getExpressionString());
                for (int i = 1; i < this.inputExpressions.size(); ++i) {
                    builder.append(", ").append(this.inputExpressions.get(i).getExpressionString());
                }
            }
            this.appendAttributes(builder);
            this.parametersString = builder.toString();
        }
        return this.parametersString;
    }

    protected void appendAttributes(StringBuilder builder) {
        if (!this.inputAttributes.isEmpty()) {
            builder.append(", ");
            Iterator<Map.Entry<String, String>> iterator = this.inputAttributes.entrySet().iterator();
            Map.Entry<String, String> entry = iterator.next();
            builder.append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
            while (iterator.hasNext()) {
                entry = iterator.next();
                builder.append(", ").append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
            }
        }
    }

    public List<String> getInputExpressionsAsStringList() {
        if (TAggregationType.COUNT_IF.equals((Object)this.aggregationType)) {
            return this.inputExpressions.stream().map(Expression::getExpressionString).collect(Collectors.toList());
        }
        return Collections.singletonList(this.getInputString(this.inputExpressions));
    }

    public String getInputString(List<Expression> expressions) {
        StringBuilder builder = new StringBuilder();
        if (!expressions.isEmpty()) {
            builder.append(expressions.get(0).getExpressionString());
            for (int i = 1; i < expressions.size(); ++i) {
                builder.append(", ").append(expressions.get(i).getExpressionString());
            }
        }
        this.appendAttributes(builder);
        return builder.toString();
    }

    public List<Expression> getInputExpressions() {
        return this.inputExpressions;
    }

    public Map<String, String> getInputAttributes() {
        return this.inputAttributes;
    }

    public TAggregationType getAggregationType() {
        return this.aggregationType;
    }

    public AggregationStep getStep() {
        return this.step;
    }

    public void setStep(AggregationStep step) {
        this.step = step;
    }

    public void setInputExpressions(List<Expression> inputExpressions) {
        this.inputExpressions = inputExpressions;
    }

    public AggregationDescriptor deepClone() {
        return new AggregationDescriptor(this);
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.aggregationFuncName, (ByteBuffer)byteBuffer);
        this.step.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.inputExpressions.size(), (ByteBuffer)byteBuffer);
        for (Expression expression : this.inputExpressions) {
            Expression.serialize(expression, byteBuffer);
        }
        ReadWriteIOUtils.write(this.inputAttributes, (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.aggregationFuncName, (OutputStream)stream);
        this.step.serialize(stream);
        ReadWriteIOUtils.write((int)this.inputExpressions.size(), (OutputStream)stream);
        for (Expression expression : this.inputExpressions) {
            Expression.serialize(expression, stream);
        }
        ReadWriteIOUtils.write(this.inputAttributes, (OutputStream)stream);
    }

    public static AggregationDescriptor deserialize(ByteBuffer byteBuffer) {
        int inputExpressionsSize;
        String aggregationFuncName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        AggregationStep step = AggregationStep.deserialize(byteBuffer);
        ArrayList<Expression> inputExpressions = new ArrayList<Expression>(inputExpressionsSize);
        for (inputExpressionsSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); inputExpressionsSize > 0; --inputExpressionsSize) {
            inputExpressions.add(Expression.deserialize(byteBuffer));
        }
        LinkedHashMap inputAttributes = ReadWriteIOUtils.readLinkedHashMap((ByteBuffer)byteBuffer);
        return new AggregationDescriptor(aggregationFuncName, step, inputExpressions, inputAttributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationDescriptor that = (AggregationDescriptor)o;
        return this.aggregationType == that.aggregationType && this.step == that.step && Objects.equals(this.inputExpressions, that.inputExpressions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregationType, this.step, this.inputExpressions});
    }

    public String toString() {
        return String.format("AggregationDescriptor(%s, %s)", new Object[]{this.aggregationFuncName, this.step});
    }
}

