/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import java.util.ArrayList;
import org.apache.iotdb.library.drepair.util.TimestampInterval;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.access.RowIterator;

public class TimestampRepair {
    protected int n;
    protected long[] time;
    protected double[] original;
    protected long[] repaired;
    protected double[] repairedValue;
    protected long deltaT;
    protected long start0;

    public TimestampRepair(RowIterator dataIterator, long intervalMode, int startPointMode) throws Exception {
        ArrayList<Long> timeList = new ArrayList<Long>();
        ArrayList<Double> originList = new ArrayList<Double>();
        while (dataIterator.hasNextRow()) {
            Row row = dataIterator.next();
            double v = Util.getValueAsDouble(row);
            timeList.add(row.getTime());
            if (!Double.isFinite(v)) {
                originList.add(Double.NaN);
                continue;
            }
            originList.add(v);
        }
        this.time = Util.toLongArray(timeList);
        this.original = Util.toDoubleArray(originList);
        this.n = this.time.length;
        TimestampInterval trParam = new TimestampInterval(this.time, this.original);
        this.deltaT = trParam.getInterval(intervalMode);
        this.start0 = trParam.getStart0(startPointMode);
    }

    private void noRepair() {
        for (int i = 0; i < this.time.length; ++i) {
            this.repaired[i] = this.time[i];
            this.repairedValue[i] = this.original[i];
        }
    }

    public void dpRepair() {
        int j;
        int i;
        if (this.time.length <= 2) {
            this.noRepair();
            return;
        }
        int n0 = (int)Math.ceil((double)(this.time[this.n - 1] - this.start0) / (double)this.deltaT + 1.0);
        this.repaired = new long[n0];
        this.repairedValue = new double[n0];
        int m0 = this.n;
        long[][] f = new long[n0 + 1][m0 + 1];
        int[][] steps = new int[n0 + 1][m0 + 1];
        int addCostRatio = 100000;
        for (i = 0; i < n0 + 1; ++i) {
            f[i][0] = (long)addCostRatio * (long)i;
            steps[i][0] = 1;
        }
        for (i = 0; i < m0 + 1; ++i) {
            f[0][i] = (long)addCostRatio * (long)i;
            steps[0][i] = 2;
        }
        for (i = 1; i < n0 + 1; ++i) {
            for (j = 1; j < m0 + 1; ++j) {
                if (this.time[j - 1] == this.start0 + (long)(i - 1) * this.deltaT) {
                    f[i][j] = f[i - 1][j - 1];
                    steps[i][j] = 0;
                    continue;
                }
                if (f[i - 1][j] < f[i][j - 1]) {
                    f[i][j] = f[i - 1][j] + (long)(addCostRatio * 1);
                    steps[i][j] = 1;
                } else {
                    f[i][j] = f[i][j - 1] + (long)(addCostRatio * 1);
                    steps[i][j] = 2;
                }
                long modifyResult = f[i - 1][j - 1] + Math.abs(this.time[j - 1] - this.start0 - (long)(i - 1) * this.deltaT);
                if (modifyResult >= f[i][j]) continue;
                f[i][j] = modifyResult;
                steps[i][j] = 0;
            }
        }
        i = n0;
        j = m0;
        while (i >= 1 && j >= 1) {
            long ps = this.start0 + (long)(i - 1) * this.deltaT;
            if (steps[i][j] == 0) {
                this.repaired[i - 1] = ps;
                this.repairedValue[i - 1] = this.original[j - 1];
                --i;
                --j;
                continue;
            }
            if (steps[i][j] == 1) {
                this.repaired[i - 1] = ps;
                this.repairedValue[i - 1] = Double.NaN;
                --i;
                continue;
            }
            --j;
        }
    }

    public double[] getRepairedValue() {
        return this.repairedValue;
    }

    public long[] getRepaired() {
        return this.repaired;
    }
}

