/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.auth.entity.PathPrivilege;

public class IOUtils {
    private IOUtils() {
    }

    public static void writeString(OutputStream outputStream, String str, String encoding, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        if (str != null) {
            byte[] strBuffer = str.getBytes(encoding);
            IOUtils.writeInt(outputStream, strBuffer.length, encodingBufferLocal);
            outputStream.write(strBuffer);
        } else {
            IOUtils.writeInt(outputStream, 0, encodingBufferLocal);
        }
    }

    public static void writeInt(OutputStream outputStream, int i, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        ByteBuffer encodingBuffer;
        if (encodingBufferLocal != null) {
            encodingBuffer = encodingBufferLocal.get();
            if (encodingBuffer == null) {
                encodingBuffer = ByteBuffer.allocate(8);
                encodingBufferLocal.set(encodingBuffer);
            }
        } else {
            encodingBuffer = ByteBuffer.allocate(4);
        }
        encodingBuffer.clear();
        encodingBuffer.putInt(i);
        outputStream.write(encodingBuffer.array(), 0, 4);
    }

    public static String readString(DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal) throws IOException {
        int length = inputStream.readInt();
        if (length > 0) {
            byte[] strBuffer;
            if (strBufferLocal != null) {
                strBuffer = strBufferLocal.get();
                if (strBuffer == null || length > strBuffer.length) {
                    strBuffer = new byte[length];
                    strBufferLocal.set(strBuffer);
                }
            } else {
                strBuffer = new byte[length];
            }
            inputStream.read(strBuffer, 0, length);
            return new String(strBuffer, 0, length, encoding);
        }
        return null;
    }

    public static PathPrivilege readPathPrivilege(DataInputStream inputStream, String encoding, ThreadLocal<byte[]> strBufferLocal) throws IOException {
        String path = IOUtils.readString(inputStream, encoding, strBufferLocal);
        int privilegeNum = inputStream.readInt();
        PathPrivilege pathPrivilege = new PathPrivilege(path);
        for (int i = 0; i < privilegeNum; ++i) {
            pathPrivilege.getPrivileges().add(inputStream.readInt());
        }
        return pathPrivilege;
    }

    public static void writePathPrivilege(OutputStream outputStream, PathPrivilege pathPrivilege, String encoding, ThreadLocal<ByteBuffer> encodingBufferLocal) throws IOException {
        IOUtils.writeString(outputStream, pathPrivilege.getPath(), encoding, encodingBufferLocal);
        IOUtils.writeInt(outputStream, pathPrivilege.getPrivileges().size(), encodingBufferLocal);
        for (Integer i : pathPrivilege.getPrivileges()) {
            IOUtils.writeInt(outputStream, i, encodingBufferLocal);
        }
    }

    public static void replaceFile(File newFile, File oldFile) throws IOException {
        if (!newFile.renameTo(oldFile)) {
            if (!oldFile.delete()) {
                throw new IOException(String.format("Cannot delete old user file : %s", oldFile.getPath()));
            }
            if (!newFile.renameTo(oldFile)) {
                throw new IOException(String.format("Cannot replace old user file with new one : %s", newFile.getPath()));
            }
        }
    }

    public static ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        original.rewind();
        clone.put(original);
        original.rewind();
        clone.flip();
        return clone;
    }
}

