/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.batch;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.livy.LivyConf;
import org.apache.livy.Logging;
import org.apache.livy.Utils$;
import org.apache.livy.server.AccessManager;
import org.apache.livy.server.batch.BatchRecoveryMetadata;
import org.apache.livy.server.batch.BatchSession;
import org.apache.livy.server.batch.CreateBatchRequest;
import org.apache.livy.server.recovery.SessionStore;
import org.apache.livy.sessions.Session$;
import org.apache.livy.sessions.SessionState;
import org.apache.livy.utils.LineBufferedProcess;
import org.apache.livy.utils.SparkApp;
import org.apache.livy.utils.SparkApp$;
import org.apache.livy.utils.SparkAppListener;
import org.apache.livy.utils.SparkProcessBuilder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

public final class BatchSession$
implements Logging {
    public static BatchSession$ MODULE$;
    private final String RECOVERY_SESSION_TYPE;
    private final AtomicInteger bscpn;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new BatchSession$();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        BatchSession$ batchSession$ = this;
        synchronized (batchSession$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String RECOVERY_SESSION_TYPE() {
        return this.RECOVERY_SESSION_TYPE;
    }

    private AtomicInteger bscpn() {
        return this.bscpn;
    }

    public AtomicInteger childProcesses() {
        return this.bscpn();
    }

    public BatchSession create(int id, Option<String> name, CreateBatchRequest request, LivyConf livyConf, AccessManager accessManager, String owner, Option<String> proxyUser, SessionStore sessionStore, Option<SparkApp> mockApp) {
        String appTag = new StringBuilder(12).append("livy-batch-").append(id).append("-").append(Random$.MODULE$.alphanumeric().take(8).mkString()).toString();
        Option<String> impersonatedUser = accessManager.checkImpersonation(proxyUser, owner);
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Creating batch session ").append(id).append(": [owner: ").append(owner).append(", request: ").append(request).append("]").toString());
        return new BatchSession(id, name, appTag, (SessionState)SessionState.Starting$.MODULE$, livyConf, owner, impersonatedUser, sessionStore, (Function1<BatchSession, SparkApp>)((Function1)mockApp.map((Function1 & Serializable & scala.Serializable)m -> (Function1 & Serializable & scala.Serializable)x$1 -> m).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Function1 & Serializable & scala.Serializable)s -> BatchSession$.createSparkApp$1(s, appTag, livyConf, request, impersonatedUser, sessionStore, id))));
    }

    public Option<SparkApp> create$default$9() {
        return None$.MODULE$;
    }

    public BatchSession recover(BatchRecoveryMetadata m2, LivyConf livyConf, SessionStore sessionStore, Option<SparkApp> mockApp) {
        return new BatchSession(m2.id(), m2.name(), m2.appTag(), (SessionState)SessionState.Recovering$.MODULE$, livyConf, m2.owner(), m2.proxyUser(), sessionStore, (Function1<BatchSession, SparkApp>)((Function1)mockApp.map((Function1 & Serializable & scala.Serializable)m -> (Function1 & Serializable & scala.Serializable)x$2 -> m).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Function1 & Serializable & scala.Serializable)s -> SparkApp$.MODULE$.create(m2.appTag(), m2.appId(), (Option<LineBufferedProcess>)None$.MODULE$, livyConf, (Option<SparkAppListener>)Option$.MODULE$.apply(s)))));
    }

    public Option<SparkApp> recover$default$4() {
        return None$.MODULE$;
    }

    private static final SparkApp createSparkApp$1(BatchSession s, String appTag$1, LivyConf livyConf$1, CreateBatchRequest request$1, Option impersonatedUser$1, SessionStore sessionStore$1, int id$1) {
        Map<String, String> conf = SparkApp$.MODULE$.prepareSparkConf(appTag$1, livyConf$1, Session$.MODULE$.prepareConf(request$1.conf(), (Seq<String>)request$1.jars(), (Seq<String>)request$1.files(), (Seq<String>)request$1.archives(), (Seq<String>)request$1.pyFiles(), livyConf$1));
        Predef$.MODULE$.require(request$1.file() != null, (Function0 & Serializable & scala.Serializable)() -> "File is required.");
        SparkProcessBuilder builder = new SparkProcessBuilder(livyConf$1);
        builder.conf((Traversable<Tuple2<String, String>>)conf);
        impersonatedUser$1.foreach((Function1 & Serializable & scala.Serializable)proxyUser -> builder.proxyUser((String)proxyUser));
        request$1.className().foreach((Function1 & Serializable & scala.Serializable)className -> builder.className((String)className));
        request$1.driverMemory().foreach((Function1 & Serializable & scala.Serializable)driverMemory -> builder.driverMemory((String)driverMemory));
        request$1.driverCores().foreach((Function1 & Serializable & scala.Serializable)driverCores -> builder.driverCores(BoxesRunTime.unboxToInt((Object)driverCores)));
        request$1.executorMemory().foreach((Function1 & Serializable & scala.Serializable)executorMemory -> builder.executorMemory((String)executorMemory));
        request$1.executorCores().foreach((Function1 & Serializable & scala.Serializable)executorCores -> builder.executorCores(BoxesRunTime.unboxToInt((Object)executorCores)));
        request$1.numExecutors().foreach((Function1 & Serializable & scala.Serializable)numExecutors -> builder.numExecutors(BoxesRunTime.unboxToInt((Object)numExecutors)));
        request$1.queue().foreach((Function1 & Serializable & scala.Serializable)queue -> builder.queue((String)queue));
        request$1.name().foreach((Function1 & Serializable & scala.Serializable)name -> builder.name((String)name));
        sessionStore$1.save(MODULE$.RECOVERY_SESSION_TYPE(), s.recoveryMetadata());
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        builder.redirectErrorStream(true);
        String file = (String)Session$.MODULE$.resolveURIs((Seq<String>)((Seq)new .colon.colon((Object)request$1.file(), (List)Nil$.MODULE$)), livyConf$1).apply(0);
        LineBufferedProcess sparkSubmit = builder.start((Option<String>)new Some((Object)file), (Traversable<String>)request$1.args());
        Utils$.MODULE$.startDaemonThread(new StringBuilder(22).append("batch-session-process-").append(id$1).toString(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.childProcesses().incrementAndGet();
            try {
                int n = sparkSubmit.waitFor();
                switch (n) {
                    case 0: {
                        break;
                    }
                    default: {
                        MODULE$.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("spark-submit exited with code ").append(n).toString());
                        break;
                    }
                }
            }
            finally {
                MODULE$.childProcesses().decrementAndGet();
            }
        });
        return SparkApp$.MODULE$.create(appTag$1, (Option<String>)None$.MODULE$, (Option<LineBufferedProcess>)Option$.MODULE$.apply((Object)sparkSubmit), livyConf$1, (Option<SparkAppListener>)Option$.MODULE$.apply((Object)s));
    }

    private BatchSession$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.RECOVERY_SESSION_TYPE = "batch";
        this.bscpn = new AtomicInteger();
    }
}

