/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.apache.livy.LivyClient;
import org.apache.livy.LivyClientFactory;

public final class LivyClientBuilder {
    public static final String LIVY_URI_KEY = "livy.uri";
    private final Properties config = new Properties();

    public LivyClientBuilder() throws IOException {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LivyClientBuilder(boolean loadDefaults) throws IOException {
        if (loadDefaults) {
            String[] confFiles;
            for (String file : confFiles = new String[]{"spark-defaults.conf", "livy-client.conf"}) {
                URL url = this.classLoader().getResource(file);
                if (url == null) continue;
                try (InputStreamReader r = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                    this.config.load(r);
                }
            }
        }
    }

    public LivyClientBuilder setURI(URI uri) {
        this.config.setProperty(LIVY_URI_KEY, uri.toString());
        return this;
    }

    public LivyClientBuilder setConf(String key, String value) {
        if (value != null) {
            this.config.setProperty(key, value);
        } else {
            this.config.remove(key);
        }
        return this;
    }

    public LivyClientBuilder setAll(Map<String, String> props) {
        this.config.putAll(props);
        return this;
    }

    public LivyClientBuilder setAll(Properties props) {
        this.config.putAll((Map<?, ?>)props);
        return this;
    }

    public LivyClient build() {
        URI uri;
        String uriStr = this.config.getProperty(LIVY_URI_KEY);
        if (uriStr == null) {
            throw new IllegalArgumentException("URI must be provided.");
        }
        try {
            uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI.", e);
        }
        LivyClient client = null;
        ServiceLoader<LivyClientFactory> loader = ServiceLoader.load(LivyClientFactory.class, this.classLoader());
        if (!loader.iterator().hasNext()) {
            throw new IllegalStateException("No LivyClientFactory implementation was found.");
        }
        Object error = null;
        for (LivyClientFactory factory : loader) {
            try {
                client = factory.createClient(uri, this.config);
            }
            catch (Exception e2) {
                RuntimeException e2;
                if (!(e2 instanceof RuntimeException)) {
                    e2 = new RuntimeException(e2);
                }
                throw (RuntimeException)e2;
            }
            if (client == null) continue;
            break;
        }
        if (client == null) {
            if (uri.getUserInfo() != null) {
                try {
                    uri = new URI(uri.getScheme(), "[redacted]", uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new IllegalArgumentException(String.format("URI '%s' is not supported by any registered client factories.", uri));
        }
        return client;
    }

    private ClassLoader classLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }
}

