/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.livy.thriftserver.session.ColumnBuffer;
import org.apache.livy.thriftserver.session.DataType;
import org.apache.livy.thriftserver.session.ScalaIterator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;

public class ResultSet {
    private final ColumnBuffer[] columns;

    public ResultSet() {
        this.columns = null;
    }

    public ResultSet(DataType[] types) {
        this.columns = new ColumnBuffer[types.length];
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = new ColumnBuffer(types[i]);
        }
    }

    public void addRow(Object[] fields) {
        if (fields.length != this.columns.length) {
            throw new IllegalArgumentException("Not enough columns in given row.");
        }
        for (int i = 0; i < fields.length; ++i) {
            Object value = this.columns[i].getType() == DataType.STRING ? this.toHiveString(fields[i], false) : fields[i];
            this.columns[i].add(value);
        }
    }

    public ColumnBuffer[] getColumns() {
        return this.columns;
    }

    private String toHiveString(Object value, boolean quoteStrings) {
        if (value == null) {
            return null;
        }
        if (quoteStrings && value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).stripTrailingZeros().toString();
        }
        if (value instanceof Map) {
            return this.stream(new ScalaIterator(((Map)value).iterator())).map(o -> this.toHiveString(o, true)).sorted().collect(Collectors.joining(",", "{", "}"));
        }
        if (value instanceof Seq) {
            return this.stream(new ScalaIterator(((Seq)value).iterator())).map(o -> this.toHiveString(o, true)).collect(Collectors.joining(",", "[", "]"));
        }
        if (value instanceof Tuple2) {
            Tuple2 t = (Tuple2)value;
            return String.format("%s:%s", this.toHiveString(t._1(), true), this.toHiveString(t._2(), true));
        }
        if (value instanceof Row) {
            Row r = (Row)value;
            StructField[] fields = r.schema().fields();
            AtomicInteger idx = new AtomicInteger();
            return this.stream(new ScalaIterator(r.toSeq().iterator())).map(o -> {
                String fname = fields[idx.getAndIncrement()].name();
                String fval = this.toHiveString(o, true);
                return String.format("\"%s\":%s", fname, fval);
            }).collect(Collectors.joining(",", "{", "}"));
        }
        return value.toString();
    }

    private Stream<?> stream(Iterator<?> it) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }
}

