/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import * as React from "react";
import { useState } from "react";
import {
  Dropdown,
  DropdownGroup,
  DropdownItem,
  DropdownPosition,
  DropdownToggle,
} from "@patternfly/react-core/dist/js/components/Dropdown";
import { TrashIcon } from "@patternfly/react-icons/dist/js/icons/trash-icon";

export function DeleteDropdownWithConfirmation(
  props: {
    onDelete: () => void;
    item: React.ReactNode;
    label?: string;
    isHoverable?: boolean;
  } = { onDelete: () => {}, item: <></>, isHoverable: true }
) {
  const [isDeleteDropdownOpen, setDeleteDropdownOpen] = useState(false);
  return (
    <Dropdown
      onClick={(e) => e.stopPropagation()}
      className={props.isHoverable ? "kie-tools--masthead-hoverable" : ""}
      onSelect={() => setDeleteDropdownOpen(false)}
      isOpen={isDeleteDropdownOpen}
      isPlain={true}
      position={DropdownPosition.right}
      toggle={
        <DropdownToggle
          icon={<TrashIcon />}
          toggleIndicator={null}
          onToggle={setDeleteDropdownOpen}
          onClick={(e) => e.stopPropagation()}
        >
          {props.label}
        </DropdownToggle>
      }
      dropdownItems={[
        <DropdownGroup label={"Are you sure?"} key="confirm-delete">
          <DropdownItem onClick={props.onDelete}>{props.item}</DropdownItem>
        </DropdownGroup>,
      ]}
    />
  );
}
