<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
  -->

# Kogito Maven Plugin

This Maven plugin aims to manage the code generation assets during the compile time of a Kogito application.

Supported frameworks of this plugin are:
- Apache KIE plain Java projects;
- Apache KIE Springboot based projects;

During the execution, the plugin will discover all Apache KIE assets, which are:
- Decisions (DMN);
- Predictions (PMML);
- Processes (BPMN);
- Rules (DRL)
  
and will generate and compile all the Java Classes auto-generated by the Kogito Codegen layer 
(see the `kogito-coden-modules`) that are mandatory for a correct Kogito application operation.

## How to use it

In your Kogito project root `pom.xml` file, add the following plugin declaration:

```      
<plugin>
    <groupId>org.kie.kogito</groupId>
    <artifactId>kogito-maven-plugin</artifactId>
    <version>${version.org.kie.kogito}</version>
    <executions>
        <execution>
            <phase>compile</phase>
            <goals>
              <goal>generateModel</goal>
            </goals>
        </execution>
    </executions>
</plugin>
```