import { BaseEditorResources, EditorResources, JsResource } from "../../common/EditorResources";
export interface WorkerJSResource extends JsResource {
    workerName: string;
}
interface ServerlessWorkflowResources extends EditorResources {
    workersJSResources: WorkerJSResource[];
}
export declare class ServerlessWorkflowTextEditorResources extends BaseEditorResources {
    private readonly JS_RESOURCES_EXPR;
    private readonly JS_WORKER_EXPR;
    private readonly JS_BUNDLES_EXPR;
    get(args: {
        resourcesPathPrefix: string;
    }): ServerlessWorkflowResources;
    getReferencedJSPaths(resourcesPathPrefix: string): JsResource[];
    getWorkersJSResources(resourcesPathPrefix: string): {
        path: string;
        content: string;
        userAgentCondition?: string;
        workerName: string;
    }[];
    private getJSResources;
    getReferencedCSSPaths(resourcesPathPrefix: string, gwtModuleName: string): never[];
    getFontResources(): {
        family: string;
        sources: {
            mimeType: string;
            content: string;
            format: string;
        }[];
    }[];
    getEditorResourcesPath(): string;
    getTemplatePath(): string;
    getHtmlOutputPath(): string;
}
export {};
//# sourceMappingURL=SwfTextEditorResources.d.ts.map