var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useEffect, useState } from "react";
import _ from "lodash";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { LoadMore } from "@kie-tools/runtime-tools-components/dist/components/LoadMore";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools/OuiaUtils";
import TaskInboxToolbar from "../TaskInboxToolbar/TaskInboxToolbar";
import { getDateColumn, getDefaultColumn, getTaskDescriptionColumn, getTaskStateColumn } from "../utils/TaskInboxUtils";
const UserTaskLoadingComponent = (React.createElement(Bullseye, null,
    React.createElement(KogitoSpinner, { spinnerText: "Loading user tasks...", ouiaId: "task-inbox-loading-tasks" })));
const TaskInbox = ({ isEnvelopeConnectedToChannel, initialState, driver, allTaskStates, activeTaskStates, currentUser, ouiaId, ouiaSafe, }) => {
    const [queryFilter, setQueryFilter] = useState({
        taskStates: [],
        taskNames: [],
    });
    const [allStates, setAllStates] = useState([]);
    const [activeStates, setActiveStates] = useState([]);
    const [sortBy, setSortBy] = useState({
        property: "lastUpdate",
        direction: "desc",
    });
    const [pageSize] = useState(10);
    const [isLoading, setIsLoading] = useState(true);
    const [isLoadingMore, setIsLoadingMore] = useState(false);
    const [offset, setOffset] = useState(0);
    const [error, setError] = useState(undefined);
    const [showEmptyFiltersError, setShowEmptyFiltersError] = useState(false);
    const [tasks, setTasks] = useState([]);
    const [columns] = useState([
        getTaskDescriptionColumn((task) => driver.openTask(task)),
        getDefaultColumn("processId", "Process", true),
        getDefaultColumn("priority", "Priority", true),
        getTaskStateColumn(),
        getDateColumn("started", "Started"),
        getDateColumn("lastUpdate", "Last update"),
    ]);
    const getTableSortBy = () => {
        return {
            index: columns.findIndex((column) => column.path === sortBy.property),
            direction: sortBy.direction,
        };
    };
    const initDefault = () => __awaiter(void 0, void 0, void 0, function* () {
        const defaultState = {
            filters: {
                taskStates: [...(activeTaskStates !== null && activeTaskStates !== void 0 ? activeTaskStates : [])],
                taskNames: [],
            },
            sortBy,
            currentPage: { offset: 0, limit: 10 },
        };
        yield driver.setInitialState(defaultState);
        setQueryFilter(defaultState.filters);
        setIsLoading(true);
        setSortBy(defaultState.sortBy);
        doQueryTasks(0, pageSize, true);
    });
    const initWithState = (initialState) => __awaiter(void 0, void 0, void 0, function* () {
        setQueryFilter(initialState.filters);
        setSortBy(initialState.sortBy);
        setOffset(initialState.currentPage.offset);
        setIsLoading(true);
        const limit = initialState.currentPage.offset + pageSize;
        doQueryTasks(0, limit, true);
    });
    const doQueryTasks = (_offset, _limit, _resetTasks, _resetPagination = false, _loadMore = false) => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoadingMore(_loadMore);
        setError(null);
        try {
            const response = yield driver.query(_offset, _limit);
            if (_resetTasks) {
                setTasks(response);
            }
            else {
                setTasks(tasks.concat(response));
            }
            if (_resetPagination) {
                setOffset(_offset);
            }
        }
        catch (err) {
            setError(err);
        }
        finally {
            setIsLoading(false);
            setIsLoadingMore(false);
        }
    });
    const doApplyFilter = (filter) => __awaiter(void 0, void 0, void 0, function* () {
        setQueryFilter(filter);
        if (!filter || (_.isEmpty(filter.taskStates) && _.isEmpty(filter.taskNames))) {
            setShowEmptyFiltersError(true);
            return;
        }
        setShowEmptyFiltersError(false);
        setIsLoading(true);
        yield driver.applyFilter(filter);
        doQueryTasks(0, pageSize, true, true);
    });
    const doRefresh = () => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        doQueryTasks(0, pageSize, true, true);
    });
    const onSort = (index, direction) => __awaiter(void 0, void 0, void 0, function* () {
        const sortObj = {
            property: columns[index].path,
            direction: direction.toLowerCase(),
        };
        yield driver.applySorting(sortObj);
        setSortBy(sortObj);
        setIsLoading(true);
        yield doQueryTasks(0, pageSize, true, true);
    });
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        setAllStates(allTaskStates !== null && allTaskStates !== void 0 ? allTaskStates : []);
        setActiveStates(activeTaskStates !== null && activeTaskStates !== void 0 ? activeTaskStates : []);
        if (!initialState) {
            initDefault();
        }
        else {
            initWithState(initialState);
        }
    }, [isEnvelopeConnectedToChannel]);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel && currentUser && currentUser.length > 0) {
            initDefault();
        }
    }, [isEnvelopeConnectedToChannel, currentUser]);
    if (error) {
        return React.createElement(ServerErrors, { error: error, variant: "large" });
    }
    const mustShowMore = () => {
        if (!isLoadingMore) {
            const limit = offset * pageSize + pageSize;
            return !isLoading && limit === tasks.length;
        }
        return true;
    };
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "task-inbox", ouiaSafe)),
        React.createElement(TaskInboxToolbar, { activeFilter: queryFilter, allTaskStates: allStates, activeTaskStates: activeStates, applyFilter: doApplyFilter, refresh: doRefresh }),
        showEmptyFiltersError ? (React.createElement(KogitoEmptyState, { type: KogitoEmptyStateType.Reset, title: "No status is selected", body: "Try selecting at least one status to see results", onClick: () => doApplyFilter({ taskStates: activeStates, taskNames: [] }), ouiaId: "task-inbox-no-status" })) : (React.createElement(React.Fragment, null,
            React.createElement(DataTable, { data: tasks, isLoading: isLoading, columns: columns, error: false, sortBy: getTableSortBy(), onSorting: onSort, LoadingComponent: UserTaskLoadingComponent }),
            mustShowMore() && (React.createElement(LoadMore, { offset: offset, setOffset: setOffset, getMoreItems: (_offset, _limit) => doQueryTasks(_offset, _limit, false, true, true), pageSize: pageSize, isLoadingMore: isLoadingMore }))))));
};
export default TaskInbox;
//# sourceMappingURL=TaskInbox.js.map