import { MessageBusClientApi } from "@kie-tools-core/envelope-bus/dist/api";
import { QueryFilter, SortBy, TaskInboxChannelApi, TaskInboxDriver, TaskInboxState } from "../api";
import { UserTaskInstance } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
export default class TaskInboxEnvelopeViewDriver implements TaskInboxDriver {
    private readonly channelApi;
    constructor(channelApi: MessageBusClientApi<TaskInboxChannelApi>);
    setInitialState(taskInboxState: TaskInboxState): Promise<void>;
    applyFilter(filter: QueryFilter): Promise<void>;
    applySorting(sortBy: SortBy): Promise<void>;
    query(offset: number, limit: number): Promise<UserTaskInstance[]>;
    openTask(task: UserTaskInstance): void;
}
//# sourceMappingURL=TaskInboxEnvelopeViewDriver.d.ts.map