var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React, { useCallback, useEffect, useState } from "react";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Grid, GridItem } from "@patternfly/react-core/dist/js/layouts/Grid";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { OverflowMenu, OverflowMenuContent, OverflowMenuGroup, } from "@patternfly/react-core/dist/js/components/OverflowMenu";
import { Card } from "@patternfly/react-core/dist/js/components/Card";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import ProcessDiagram from "../ProcessDiagram/ProcessDiagram";
import JobsPanel from "../JobsPanel/JobsPanel";
import ProcessDetailsErrorModal from "../ProcessDetailsErrorModal/ProcessDetailsErrorModal";
import SVG from "react-inlinesvg";
import "../styles.css";
import ProcessDetailsPanel from "../ProcessDetailsPanel/ProcessDetailsPanel";
import ProcessDetailsNodeTrigger from "../ProcessDetailsNodeTrigger/ProcessDetailsNodeTrigger";
import ProcessVariables from "../ProcessVariables/ProcessVariables";
import ProcessDetailsMilestonesPanel from "../ProcessDetailsMilestonesPanel/ProcessDetailsMilestonesPanel";
import ProcessDetailsTimelinePanel from "../ProcessDetailsTimelinePanel/ProcessDetailsTimelinePanel";
import { TitleType, } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { ProcessInfoModal } from "@kie-tools/runtime-tools-components/dist/components/ProcessInfoModal";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
const ProcessDetails = ({ isEnvelopeConnectedToChannel, driver, processDetails, omittedProcessTimelineEvents, diagramPreviewSize, showSwfDiagram, singularProcessLabel, pluralProcessLabel, }) => {
    var _a;
    const [data, setData] = useState({});
    const [jobs, setJobs] = useState([]);
    const [updateJson, setUpdateJson] = useState({});
    const [displayLabel, setDisplayLabel] = useState(false);
    const [displaySuccess, setDisplaySuccess] = useState(false);
    const [errorModalOpen, setErrorModalOpen] = useState(false);
    const [confirmationModal, setConfirmationModal] = useState(false);
    const [variableError, setVariableError] = useState("");
    const [svg, setSvg] = useState();
    const [svgError, setSvgError] = useState("");
    const [error, setError] = useState("");
    const [svgErrorModalOpen, setSvgErrorModalOpen] = useState(false);
    const [isLoading, setIsLoading] = useState(false);
    const [isInfoModalOpen, setIsInfoModalOpen] = useState(false);
    const [infoModalTitle, setInfoModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [infoModalContent, setInfoModalContent] = useState("");
    const handleReload = () => __awaiter(void 0, void 0, void 0, function* () {
        setIsLoading(true);
        try {
            const processResponse = yield driver.processDetailsQuery(processDetails.id);
            processResponse && setData(processResponse);
            loadJobs();
            setIsLoading(false);
        }
        catch (errorString) {
            setError(errorString);
            setIsLoading(false);
        }
    });
    const loadJobs = useCallback(() => __awaiter(void 0, void 0, void 0, function* () {
        const jobsResponse = yield driver.jobsQuery(processDetails.id);
        jobsResponse && setJobs(jobsResponse);
    }), [processDetails.id, driver]);
    const handleSvgErrorModal = () => {
        setSvgErrorModalOpen(!svgErrorModalOpen);
    };
    const errorModalAction = [
        React.createElement(Button, { "data-testid": "svg-error-modal", key: "confirm-selection", variant: "primary", onClick: handleSvgErrorModal }, "OK"),
    ];
    useEffect(() => {
        const handleSvgApi = () => __awaiter(void 0, void 0, void 0, function* () {
            if (data && data.id === processDetails.id) {
                const response = yield driver.getProcessDiagram(data);
                if (response && response.svg) {
                    const temp = React.createElement(SVG, { src: response.svg });
                    setSvg(temp);
                }
                else if (response && response.error) {
                    setSvgError(response.error);
                }
            }
        });
        const getVariableJSON = () => {
            if (data && data.id === processDetails.id) {
                setUpdateJson(data.variables);
            }
        };
        if (isEnvelopeConnectedToChannel) {
            handleSvgApi();
            getVariableJSON();
        }
    }, [driver, data, isEnvelopeConnectedToChannel, processDetails.id]);
    useEffect(() => {
        if (svgError && svgError.length > 0 && !showSwfDiagram) {
            setSvgErrorModalOpen(true);
        }
    }, [svgError, showSwfDiagram]);
    useEffect(() => {
        if (variableError && variableError.length > 0) {
            setErrorModalOpen(true);
        }
    }, [variableError]);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            setData(processDetails);
            loadJobs();
        }
    }, [isEnvelopeConnectedToChannel, loadJobs, processDetails]);
    const handleSave = () => {
        driver
            .handleProcessVariableUpdate(data, updateJson)
            .then((updatedJson) => {
            setUpdateJson(updatedJson);
            setDisplayLabel(false);
            setDisplaySuccess(true);
            setTimeout(() => {
                setDisplaySuccess(false);
            }, 2000);
        })
            .catch((errorMessage) => {
            setVariableError(errorMessage);
        });
    };
    const updateVariablesButton = () => {
        if (data.serviceUrl !== null) {
            return (React.createElement(Button, { variant: "secondary", id: "save-button", className: "kogito-process-details--details__buttonMargin", onClick: handleSave, isDisabled: !displayLabel, "data-testid": "save-button" }, "Save"));
        }
        return React.createElement(React.Fragment, null);
    };
    const handleRefresh = () => {
        if (displayLabel) {
            setConfirmationModal(true);
        }
        else {
            handleReload();
        }
    };
    const refreshButton = () => {
        return (React.createElement(Button, { variant: "plain", onClick: () => {
                handleRefresh();
            }, id: "refresh-button", "data-testid": "refresh-button", "aria-label": "Refresh list" },
            React.createElement(SyncIcon, null)));
    };
    const handleInfoModalToggle = () => {
        setIsInfoModalOpen(!isInfoModalOpen);
    };
    const onAbortClick = (processInstance) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            yield driver.handleProcessAbort(processInstance);
            setTitleType(TitleType.SUCCESS);
            setInfoModalTitle("Abort operation");
            setInfoModalContent(`The ${singularProcessLabel.toLowerCase()} ${processInstance.processName} was successfully aborted.`);
        }
        catch (abortError) {
            setTitleType(TitleType.FAILURE);
            setInfoModalTitle("Abort operation");
            setInfoModalContent(`Failed to abort ${singularProcessLabel.toLowerCase()} ${processInstance.processName}. Message: ${abortError.message}`);
        }
        finally {
            handleInfoModalToggle();
        }
    });
    const abortButton = () => {
        if ((data.state === ProcessInstanceState.Active ||
            data.state === ProcessInstanceState.Error ||
            data.state === ProcessInstanceState.Suspended) &&
            data.addons.includes("process-management") &&
            data.serviceUrl !== null) {
            return (React.createElement(Button, { variant: "secondary", id: "abort-button", "data-testid": "abort-button", onClick: () => onAbortClick(data) }, "Abort"));
        }
        else {
            return (React.createElement(Button, { variant: "secondary", isDisabled: true }, "Abort"));
        }
    };
    const renderProcessDiagram = () => {
        return (React.createElement(Flex, null,
            React.createElement(FlexItem, null, svg && svg.props.src && (React.createElement(Card, null,
                " ",
                React.createElement(ProcessDiagram, { svg: svg, width: diagramPreviewSize === null || diagramPreviewSize === void 0 ? void 0 : diagramPreviewSize.width, height: diagramPreviewSize === null || diagramPreviewSize === void 0 ? void 0 : diagramPreviewSize.height }),
                " ")))));
    };
    const renderProcessTimeline = () => {
        return (React.createElement(FlexItem, null,
            React.createElement(ProcessDetailsTimelinePanel, { data: data, jobs: jobs, driver: driver, omittedProcessTimelineEvents: omittedProcessTimelineEvents })));
    };
    const renderProcessDetails = () => {
        return (React.createElement(Flex, { direction: { default: "column" }, flex: { default: "flex_1" } },
            React.createElement(FlexItem, null,
                React.createElement(ProcessDetailsPanel, { processInstance: data, driver: driver })),
            data.milestones && data.milestones.length > 0 && (React.createElement(FlexItem, null,
                React.createElement(ProcessDetailsMilestonesPanel, { milestones: data.milestones })))));
    };
    const renderProcessVariables = () => {
        return (React.createElement(Flex, { direction: { default: "column" }, flex: { default: "flex_1" } }, updateJson && Object.keys(updateJson).length > 0 && (React.createElement(FlexItem, null,
            React.createElement(ProcessVariables, { displayLabel: displayLabel, displaySuccess: displaySuccess, setUpdateJson: setUpdateJson, setDisplayLabel: setDisplayLabel, updateJson: updateJson, processInstance: data })))));
    };
    const renderPanels = () => {
        if (svg && svg.props.src) {
            return (React.createElement(Flex, { direction: { default: "column" } },
                renderProcessDiagram(),
                React.createElement(Flex, null,
                    renderProcessDetails(),
                    renderProcessVariables())));
        }
        else {
            return (React.createElement(React.Fragment, null,
                renderProcessDetails(),
                renderProcessVariables()));
        }
    };
    const handleConfirmationModal = () => {
        setConfirmationModal(!confirmationModal);
    };
    const handleConfirm = () => {
        window.location.reload();
        handleConfirmationModal();
    };
    const handleCancel = () => {
        handleConfirmationModal();
    };
    const RenderConfirmationModal = () => {
        return (React.createElement(Modal, { title: "", header: React.createElement(React.Fragment, null,
                React.createElement(Title, { headingLevel: "h1", size: TitleSizes["2xl"] },
                    React.createElement(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--warning-color--100)" }),
                    "Refresh")), variant: ModalVariant.small, isOpen: confirmationModal, onClose: handleConfirmationModal, actions: [
                React.createElement(Button, { key: "Ok", variant: "primary", id: "confirm-button", onClick: handleConfirm }, "Ok"),
                React.createElement(Button, { key: "Cancel", variant: "link", id: "cancel-button", onClick: handleCancel }, "Cancel"),
            ], "aria-label": "Confirmation modal", "aria-labelledby": "Confirmation modal" }, "This action discards changes made on process variables."));
    };
    const handleErrorModal = () => {
        setErrorModalOpen(!errorModalOpen);
    };
    const handleRetry = () => {
        handleErrorModal();
        setVariableError("");
        handleSave();
    };
    const handleDiscard = () => {
        handleErrorModal();
        handleRefresh();
    };
    const errorModal = () => {
        return (React.createElement(Modal, { title: "", header: React.createElement(React.Fragment, null,
                React.createElement(Title, { headingLevel: "h1", size: TitleSizes["2xl"] },
                    React.createElement(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }),
                    "Error")), variant: ModalVariant.small, isOpen: errorModalOpen, onClose: handleErrorModal, actions: [
                React.createElement(Button, { key: "Retry", variant: "primary", id: "retry-button", onClick: handleRetry }, "Retry"),
                React.createElement(Button, { key: "Discard", variant: "link", id: "discard-button", onClick: handleDiscard }, "Discard"),
            ], "aria-label": "Error modal", "aria-labelledby": "Error modal" }, variableError));
    };
    return (React.createElement(React.Fragment, null,
        !error ? (React.createElement(React.Fragment, null,
            !isLoading && Object.keys(data).length > 0 ? (React.createElement(React.Fragment, null,
                React.createElement(Grid, { hasGutter: true, md: 1, span: 12, lg: 6, xl: 4 },
                    React.createElement(GridItem, { span: 12 },
                        React.createElement(Split, { hasGutter: true, component: "div", className: "pf-u-align-items-center" },
                            React.createElement(SplitItem, { isFilled: true },
                                React.createElement(Title, { headingLevel: "h2", size: "4xl", className: "kogito-process-details--details__title" },
                                    React.createElement(ItemDescriptor, { itemDescription: {
                                            id: data.id,
                                            name: data.processName,
                                            description: data.businessKey,
                                        } }))),
                            React.createElement(SplitItem, null,
                                React.createElement(OverflowMenu, { breakpoint: "lg" },
                                    React.createElement(OverflowMenuContent, { isPersistent: true },
                                        React.createElement(OverflowMenuGroup, { groupType: "button", isPersistent: true },
                                            React.createElement(React.Fragment, null,
                                                updateVariablesButton(),
                                                abortButton(),
                                                refreshButton())))))))),
                React.createElement(Flex, { direction: { default: "column", lg: "row" }, className: "kogito-process-details--details__marginSpaces" },
                    renderPanels(),
                    React.createElement(Flex, { direction: { default: "column" }, flex: { default: "flex_1" } },
                        renderProcessTimeline(),
                        React.createElement(FlexItem, null,
                            React.createElement(JobsPanel, { jobs: jobs, driver: driver })),
                        ((_a = data.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management")) &&
                            data.state !== ProcessInstanceState.Completed &&
                            data.state !== ProcessInstanceState.Aborted &&
                            data.serviceUrl &&
                            data.addons.includes("process-management") && (React.createElement(FlexItem, null,
                            React.createElement(ProcessDetailsNodeTrigger, { driver: driver, processInstanceData: data })))),
                    errorModal(),
                    RenderConfirmationModal()))) : (React.createElement(Card, null,
                React.createElement(KogitoSpinner, { spinnerText: "Loading process details..." }))),
            svgErrorModalOpen && (React.createElement(ProcessDetailsErrorModal, { errorString: svgError, errorModalOpen: svgErrorModalOpen, errorModalAction: errorModalAction, handleErrorModal: handleSvgErrorModal, label: "svg error modal", title: setTitle("failure", "Process Diagram") })))) : (React.createElement(React.Fragment, null, isEnvelopeConnectedToChannel && (React.createElement(Card, { className: "kogito-process-details__card-size" },
            React.createElement(Bullseye, null,
                React.createElement(ServerErrors, { error: error, variant: "large" })))))),
        React.createElement(ProcessInfoModal, { isModalOpen: isInfoModalOpen, handleModalToggle: handleInfoModalToggle, modalTitle: setTitle(titleType, infoModalTitle), modalContent: infoModalContent, processName: data && data.processName })));
};
export default ProcessDetails;
//# sourceMappingURL=ProcessDetails.js.map