import * as React from "react";
import { useImperativeHandle, useState } from "react";
import JobsManagement from "./components/JobsManagement/JobsManagement";
import JobsManagementEnvelopeViewDriver from "./JobsManagementEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
export const JobsManagementEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    useImperativeHandle(forwardedRef, () => ({
        initialize: () => {
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (React.createElement(React.Fragment, null,
        React.createElement(JobsManagement, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new JobsManagementEnvelopeViewDriver(props.channelApi) })));
});
export default JobsManagementEnvelopeView;
//# sourceMappingURL=JobsManagementEnvelopeView.js.map