"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useCancelableEffect = void 0;
var react_1 = require("react");
var Holder_1 = require("./Holder");
function useCancelableEffect(effect) {
    (0, react_1.useEffect)(function () {
        var canceled = new Holder_1.Holder(false);
        var effectCleanup = effect({ canceled: canceled });
        return function () {
            canceled.set(true);
            if (effectCleanup) {
                effectCleanup();
            }
        };
    }, [effect]);
}
exports.useCancelableEffect = useCancelableEffect;
//# sourceMappingURL=useCancelableEffect.js.map