import * as React from "react";
import { WorkspaceEdit } from "@kie-tools-core/workspace/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { ChannelType, StateControlCommand } from "@kie-tools-core/editor/dist/api";
import { Position } from "monaco-editor";
import "./YardEditor.css";
interface Props {
    onStateControlCommandUpdate: (command: StateControlCommand) => void;
    onNewEdit: (edit: WorkspaceEdit) => void;
    setNotifications: (normalizedPosixPathRelativeToTheWorkspaceRoot: string, notifications: Notification[]) => void;
    channelType: ChannelType;
    isReadOnly: boolean;
}
export declare type YardEditorRef = {
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    moveCursorToPosition(position: Position): void;
};
export declare const YardEditor: React.ForwardRefExoticComponent<Props & React.RefAttributes<YardEditorRef | undefined>>;
export {};
//# sourceMappingURL=YardEditor.d.ts.map