/// <reference types="react" />
import { Editor, EditorFactory, EditorInitArgs, KogitoEditorEnvelopeContextType, KogitoEditorChannelApi, EditorTheme } from "@kie-tools-core/editor/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
export declare class DmnEditorFactory implements EditorFactory<Editor, KogitoEditorChannelApi> {
    createEditor(envelopeContext: KogitoEditorEnvelopeContextType<KogitoEditorChannelApi>, initArgs: EditorInitArgs): Promise<Editor>;
}
export declare class DmnEditorInterface implements Editor {
    private readonly envelopeContext;
    private readonly initArgs;
    private self;
    af_isReact: boolean;
    af_componentId: "dmn-editor";
    af_componentTitle: "DMN Editor";
    constructor(envelopeContext: KogitoEditorEnvelopeContextType<KogitoEditorChannelApi>, initArgs: EditorInitArgs);
    getPreview(): Promise<string | undefined>;
    validate(): Promise<Notification[]>;
    setTheme(theme: EditorTheme): Promise<void>;
    undo(): Promise<void>;
    redo(): Promise<void>;
    getContent(): Promise<string>;
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    af_componentRoot(): JSX.Element;
}
//# sourceMappingURL=DmnEditorFactory.d.ts.map