export class TaskInboxGatewayApiImpl {
    constructor(queries, getCurrentUser) {
        this.listeners = [];
        this.queries = queries;
        this.getCurrentUser = getCurrentUser;
    }
    get taskInboxState() {
        return this._taskInboxState;
    }
    setInitialState(taskInboxState) {
        this._taskInboxState = taskInboxState;
        return Promise.resolve();
    }
    clearOpenTask() {
        this.activeTask = null;
        return Promise.resolve();
    }
    openTask(task) {
        this.activeTask = task;
        this.listeners.forEach((listener) => listener.onOpen(task));
        return Promise.resolve();
    }
    applyFilter(filter) {
        this._taskInboxState.filters = filter;
        return Promise.resolve();
    }
    applySorting(sortBy) {
        this._taskInboxState.sortBy = sortBy;
        return Promise.resolve();
    }
    getTaskById(taskId) {
        if (this.activeTask && this.activeTask.id === taskId) {
            return Promise.resolve(this.activeTask);
        }
        return this.queries.getUserTaskById(taskId);
    }
    query(offset, limit) {
        return new Promise((resolve, reject) => {
            this.queries
                .getUserTasks(this.getCurrentUser(), offset, limit, this._taskInboxState.filters, this._taskInboxState.sortBy)
                .then((value) => {
                this._taskInboxState.currentPage = { offset, limit };
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    onOpenTaskListen(listener) {
        this.listeners.push(listener);
        const unSubscribe = () => {
            const index = this.listeners.indexOf(listener);
            if (index > -1) {
                this.listeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
}
//# sourceMappingURL=TaskInboxGatewayApi.js.map