import React, { useMemo } from "react";
import ProcessListContext from "./ProcessListContext";
import { ProcessListGatewayApiImpl } from "./ProcessListGatewayApi";
import { GraphQLProcessListQueries } from "./ProcessListQueries";
export const ProcessListContextProvider = ({ apolloClient, children }) => {
    const gatewayApiImpl = useMemo(() => {
        return new ProcessListGatewayApiImpl(new GraphQLProcessListQueries(apolloClient));
    }, []);
    return React.createElement(ProcessListContext.Provider, { value: gatewayApiImpl }, children);
};
export default ProcessListContextProvider;
//# sourceMappingURL=ProcessListContextProvider.js.map