import { EditorLanguageServiceCommandArgs, EditorLanguageServiceCommandExecution, EditorLanguageServiceCommandHandlers, EditorLanguageServiceCommandIds, EditorLanguageServiceCommandTypes } from "@kie-tools/json-yaml-language-service/dist/api";
import { SwfServiceCatalogService } from "@kie-tools/serverless-workflow-service-catalog/dist/api";
import { CodeLens, CompletionItem, Position, Range } from "vscode-languageserver-types";
export interface SwfLanguageServiceChannelApi {
    kogitoSwfLanguageService__getCompletionItems(args: {
        content: string;
        uri: string;
        cursorPosition: Position;
        cursorWordRange: Range;
    }): Promise<CompletionItem[]>;
    kogitoSwfLanguageService__getCodeLenses(args: {
        uri: string;
        content: string;
    }): Promise<CodeLens[]>;
}
export declare type SwfLanguageServiceCommandTypes = EditorLanguageServiceCommandTypes<"swf.ls.commands.ImportFunctionFromCompletionItem" | "swf.ls.commands.ImportEventFromCompletionItem" | "swf.ls.commands.OpenFunctionsWidget" | "swf.ls.commands.OpenStatesWidget" | "swf.ls.commands.OpenServiceRegistriesConfig" | "swf.ls.commands.LogInServiceRegistries" | "swf.ls.commands.RefreshServiceRegistries">;
export declare type SwfLanguageServiceCommandArgs = EditorLanguageServiceCommandArgs & {
    "swf.ls.commands.ImportFunctionFromCompletionItem": {
        containingService: SwfServiceCatalogService;
        documentUri: string;
    };
    "swf.ls.commands.ImportEventFromCompletionItem": {
        containingService: SwfServiceCatalogService;
        documentUri: string;
    };
    "swf.ls.commands.OpenFunctionsWidget": {
        position: Position;
    };
    "swf.ls.commands.OpenStatesWidget": {
        position: Position;
    };
    "swf.ls.commands.OpenServiceRegistriesConfig": {};
    "swf.ls.commands.LogInServiceRegistries": {};
    "swf.ls.commands.RefreshServiceRegistries": {};
};
export declare type SwfLanguageServiceCommandIds = EditorLanguageServiceCommandIds<SwfLanguageServiceCommandTypes>;
export declare type SwfLanguageServiceCommandHandlers = EditorLanguageServiceCommandHandlers<SwfLanguageServiceCommandTypes, SwfLanguageServiceCommandArgs>;
export interface SwfLanguageServiceCommandExecution<T extends SwfLanguageServiceCommandTypes> extends EditorLanguageServiceCommandExecution<T, SwfLanguageServiceCommandArgs> {
}
//# sourceMappingURL=SwfLanguageServiceChannelApi.d.ts.map