"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isInvalidValueReplacementRequired = exports.isMissingValueReplacementRequired = exports.areLowHighValuesRequired = exports.validateMiningFieldDataFieldReference = exports.validateMiningFieldsDataFieldReference = exports.validateMiningField = exports.validateMiningFields = void 0;
var ValidationRegistry_1 = require("./ValidationRegistry");
var ValidationLevel_1 = require("./ValidationLevel");
var paths_1 = require("../paths");
var validateMiningFields = function (modelIndex, miningFields, validationRegistry) {
    miningFields.forEach(function (miningField, miningFieldIndex) {
        return (0, exports.validateMiningField)(modelIndex, miningFieldIndex, miningField, validationRegistry);
    });
};
exports.validateMiningFields = validateMiningFields;
var validateMiningField = function (modelIndex, miningFieldIndex, miningField, validationRegistry) {
    var importance = miningField.importance;
    if (importance !== undefined && (importance < 0 || importance > 1)) {
        validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forImportance().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" Importance must be between 0 and 1.")));
    }
    var outliers = miningField.outliers, lowValue = miningField.lowValue, highValue = miningField.highValue;
    if ((0, exports.areLowHighValuesRequired)(outliers)) {
        if (lowValue === undefined && highValue === undefined) {
            validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forLowValue().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" Low and/or High Value must be set.")));
            validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forHighValue().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" Low and/or High Value must be set.")));
        }
    }
    else {
        if (lowValue !== undefined) {
            validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forLowValue().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" Low Value is not needed.")));
        }
        if (highValue !== undefined) {
            validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forHighValue().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" High Value is not needed.")));
        }
    }
    var missingValueTreatment = miningField.missingValueTreatment, missingValueReplacement = miningField.missingValueReplacement;
    if ((0, exports.isMissingValueReplacementRequired)(missingValueTreatment)) {
        if (missingValueReplacement === undefined) {
            validationRegistry.set((0, paths_1.Builder)()
                .forModel(modelIndex)
                .forMiningSchema()
                .forMiningField(miningFieldIndex)
                .forMissingValueReplacement()
                .build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" Missing Value Replacement must be set.")));
        }
    }
    else {
        if (missingValueReplacement !== undefined) {
            validationRegistry.set((0, paths_1.Builder)()
                .forModel(modelIndex)
                .forMiningSchema()
                .forMiningField(miningFieldIndex)
                .forMissingValueReplacement()
                .build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" Missing Value Replacement is not required.")));
        }
    }
    var invalidValueTreatment = miningField.invalidValueTreatment, invalidValueReplacement = miningField.invalidValueReplacement;
    if ((0, exports.isInvalidValueReplacementRequired)(invalidValueTreatment)) {
        if (invalidValueReplacement === undefined) {
            validationRegistry.set((0, paths_1.Builder)()
                .forModel(modelIndex)
                .forMiningSchema()
                .forMiningField(miningFieldIndex)
                .forInvalidValueReplacement()
                .build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" Invalid Value Replacement must be set.")));
        }
    }
    else {
        if (invalidValueReplacement !== undefined) {
            validationRegistry.set((0, paths_1.Builder)()
                .forModel(modelIndex)
                .forMiningSchema()
                .forMiningField(miningFieldIndex)
                .forInvalidValueReplacement()
                .build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" Invalid Value Replacement is not required.")));
        }
    }
};
exports.validateMiningField = validateMiningField;
var validateMiningFieldsDataFieldReference = function (modelIndex, dataFields, miningFields, validationRegistry) {
    miningFields.forEach(function (miningField, miningFieldIndex) {
        return (0, exports.validateMiningFieldDataFieldReference)(modelIndex, dataFields, miningFieldIndex, miningField, validationRegistry);
    });
};
exports.validateMiningFieldsDataFieldReference = validateMiningFieldsDataFieldReference;
var validateMiningFieldDataFieldReference = function (modelIndex, dataFields, miningFieldIndex, miningField, validationRegistry) {
    if (dataFields.filter(function (dataField) { return dataField.name === miningField.name; }).length === 0) {
        validationRegistry.set((0, paths_1.Builder)().forModel(modelIndex).forMiningSchema().forMiningField(miningFieldIndex).forDataFieldMissing().build(), new ValidationRegistry_1.ValidationEntry(ValidationLevel_1.ValidationLevel.WARNING, "\"".concat(miningField.name, "\" cannot be found in the Data Dictionary.")));
    }
};
exports.validateMiningFieldDataFieldReference = validateMiningFieldDataFieldReference;
var areLowHighValuesRequired = function (outliers) {
    return outliers === "asExtremeValues" || outliers === "asMissingValues";
};
exports.areLowHighValuesRequired = areLowHighValuesRequired;
var isMissingValueReplacementRequired = function (missingValueTreatment) { return missingValueTreatment === "asMean" || missingValueTreatment === "asMedian" || missingValueTreatment === "asMode"; };
exports.isMissingValueReplacementRequired = isMissingValueReplacementRequired;
var isInvalidValueReplacementRequired = function (invalidValueTreatment) { return invalidValueTreatment === "asValue"; };
exports.isInvalidValueReplacementRequired = isInvalidValueReplacementRequired;
//# sourceMappingURL=MiningSchema.js.map