"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputFieldReducer = void 0;
var Actions_1 = require("./Actions");
var paths_1 = require("../paths");
var PMMLModelHelper_1 = require("../PMMLModelHelper");
var Outputs_1 = require("../validation/Outputs");
var OutputFieldReducer = function (historyService, validationRegistry) {
    return function (state, action) {
        switch (action.type) {
            case Actions_1.Actions.UpdateOutput:
                historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forOutput().forOutputField().build(), function (draft) {
                    var outputIndex = action.payload.outputIndex;
                    if (outputIndex >= 0 && outputIndex < draft.length) {
                        draft[outputIndex] = __assign(__assign({}, draft[outputIndex]), { name: action.payload.outputField.name, dataType: action.payload.outputField.dataType, optype: action.payload.outputField.optype, targetField: action.payload.outputField.targetField, feature: action.payload.outputField.feature, value: action.payload.outputField.value, rank: action.payload.outputField.rank, rankOrder: action.payload.outputField.rankOrder, segmentId: action.payload.outputField.segmentId, isFinalResult: action.payload.outputField.isFinalResult });
                    }
                }, function (pmml) {
                    var modelIndex = action.payload.modelIndex;
                    var outputField = action.payload.outputField;
                    var outputFieldIndex = action.payload.outputIndex;
                    var miningSchema = (0, PMMLModelHelper_1.getMiningSchema)(pmml, modelIndex);
                    if (miningSchema !== undefined) {
                        validationRegistry.clear((0, paths_1.Builder)().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).forTargetField().build());
                        (0, Outputs_1.validateOutput)(modelIndex, outputField, outputFieldIndex, miningSchema.MiningField, validationRegistry);
                    }
                });
                break;
            case Actions_1.Actions.UpdateDataDictionaryField:
                state.forEach(function (outputField, index) {
                    if (outputField.targetField === action.payload.originalName) {
                        historyService.batch(state, (0, paths_1.Builder)().forModel(action.payload.modelIndex).forOutput().forOutputField().build(), function (draft) {
                            draft[index] = __assign(__assign({}, draft[index]), { targetField: action.payload.dataField.name });
                        });
                    }
                });
                break;
        }
        return state;
    };
};
exports.OutputFieldReducer = OutputFieldReducer;
//# sourceMappingURL=OutputFieldReducer.js.map