import { ActionMap, Actions, AllActions } from "./Actions";
import { HistoryAwareValidatingReducer } from "../history";
import { DataDictionary, DataType, OpType } from "@kie-tools/pmml-editor-marshaller";
interface DataDictionaryPayload {
    [Actions.AddDataDictionaryField]: {
        readonly modelIndex?: number;
        readonly name?: string;
        readonly type: DataType;
        readonly optype: OpType;
    };
    [Actions.DeleteDataDictionaryField]: {
        readonly modelIndex?: number;
        readonly index: number;
    };
    [Actions.AddBatchDataDictionaryFields]: {
        readonly modelIndex?: number;
        readonly dataDictionaryFields: string[];
    };
    [Actions.ReorderDataDictionaryFields]: {
        readonly oldIndex: number;
        readonly newIndex: number;
    };
}
export declare type DataDictionaryActions = ActionMap<DataDictionaryPayload>[keyof ActionMap<DataDictionaryPayload>];
export declare const DataDictionaryReducer: HistoryAwareValidatingReducer<DataDictionary, AllActions>;
export {};
//# sourceMappingURL=DataDictionaryReducer.d.ts.map