"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputsContainer = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var lodash_1 = require("lodash");
var react_transition_group_1 = require("react-transition-group");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Text_1 = require("@patternfly/react-core/dist/js/components/Text");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Alert_1 = require("@patternfly/react-core/dist/js/components/Alert");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var arrow_alt_circle_left_icon_1 = require("@patternfly/react-icons/dist/js/icons/arrow-alt-circle-left-icon");
var bolt_icon_1 = require("@patternfly/react-icons/dist/js/icons/bolt-icon");
var plus_icon_1 = require("@patternfly/react-icons/dist/js/icons/plus-icon");
var reducers_1 = require("../../../reducers");
var OutputFieldsTable_1 = require("./OutputFieldsTable");
var OutputsBatchAdd_1 = require("./OutputsBatchAdd");
var EditorScorecard_1 = require("../../EditorScorecard");
var OutputFieldExtendedProperties_1 = require("./OutputFieldExtendedProperties");
require("./OutputsContainer.scss");
var PMMLModelHelper_1 = require("../../../PMMLModelHelper");
var history_1 = require("../../../history");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var get = Reflect.get;
var set = Reflect.set;
var OutputsContainer = function (props) {
    var modelIndex = props.modelIndex, output = props.output, miningSchema = props.miningSchema, validateOutputFieldName = props.validateOutputFieldName, deleteOutputField = props.deleteOutputField, commitOutputField = props.commitOutputField;
    var _a = __read((0, react_1.useState)(undefined), 2), selectedOutputIndex = _a[0], setSelectedOutputIndex = _a[1];
    var _b = __read((0, react_1.useState)("overview"), 2), viewSection = _b[0], setViewSection = _b[1];
    var _c = (0, EditorScorecard_1.useOperation)(), activeOperation = _c.activeOperation, setActiveOperation = _c.setActiveOperation;
    var _d = (0, history_1.useHistoryService)(), service = _d.service, getCurrentState = _d.getCurrentState;
    var dispatch = (0, history_1.useBatchDispatch)(service, getCurrentState);
    var targetFields = (0, react_1.useMemo)(function () { return getMiningSchemaTargetFields(miningSchema); }, [miningSchema]);
    var editItem = (0, react_1.useMemo)(function () {
        if (selectedOutputIndex === undefined) {
            return undefined;
        }
        var outputs = output === null || output === void 0 ? void 0 : output.OutputField;
        if (outputs === undefined) {
            return undefined;
        }
        return outputs[selectedOutputIndex];
    }, [output, selectedOutputIndex]);
    var getTransition = function (_viewSection) {
        var cssClass;
        switch (_viewSection) {
            case "overview":
                cssClass = "outputs-container__overview";
                break;
            case "extended-properties":
                cssClass = "outputs-container__extended-properties";
                break;
            case "batch-add":
                cssClass = "outputs-container__batch-add";
                break;
        }
        return cssClass;
    };
    var addOutputField = function () {
        var _a;
        var numberOfOutputFields = output === null || output === void 0 ? void 0 : output.OutputField.length;
        if (numberOfOutputFields !== undefined) {
            var existingNames = (_a = output === null || output === void 0 ? void 0 : output.OutputField.map(function (of) { return of.name.toString(); })) !== null && _a !== void 0 ? _a : [];
            var newOutputFieldName = (0, PMMLModelHelper_1.findIncrementalName)("New output", existingNames, 1);
            var newOutputField = {
                name: newOutputFieldName,
                dataType: "string",
                optype: undefined,
                targetField: undefined,
                feature: undefined,
                value: undefined,
                rank: undefined,
                rankOrder: undefined,
                segmentId: undefined,
                isFinalResult: undefined,
            };
            setSelectedOutputIndex(numberOfOutputFields);
            setActiveOperation(EditorScorecard_1.Operation.UPDATE_OUTPUT);
            commitOutputField(undefined, newOutputField);
        }
    };
    var addBatchOutputs = function (outputs) {
        var outputsNames = outputs.split("\n").filter(function (item) { return item.trim().length > 0; });
        dispatch({
            type: reducers_1.Actions.AddBatchOutputs,
            payload: {
                modelIndex: modelIndex,
                outputFields: outputsNames,
            },
        });
        setViewSection("overview");
    };
    var onCommitAndClose = function () {
        onCommit({});
        onCancel();
    };
    var onCommit = function (partial) {
        if (output !== undefined && selectedOutputIndex !== undefined) {
            var outputField_1 = output.OutputField[selectedOutputIndex];
            var existingPartial_1 = {};
            Object.keys(partial).forEach(function (key) { return set(existingPartial_1, key, get(outputField_1, key)); });
            if (!(0, lodash_1.isEqual)(partial, existingPartial_1)) {
                commitOutputField(selectedOutputIndex, __assign(__assign({}, outputField_1), partial));
            }
        }
    };
    var onCancel = function () {
        setSelectedOutputIndex(undefined);
        setActiveOperation(EditorScorecard_1.Operation.NONE);
    };
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forModel(modelIndex).forOutput().build()); }, [modelIndex, output === null || output === void 0 ? void 0 : output.OutputField]);
    return ((0, jsx_runtime_1.jsx)("div", __assign({ className: "outputs-container" }, { children: (0, jsx_runtime_1.jsx)(react_transition_group_1.SwitchTransition, __assign({ mode: "out-in" }, { children: (0, jsx_runtime_1.jsx)(react_transition_group_1.CSSTransition, __assign({ timeout: {
                    enter: 230,
                    exit: 100,
                }, classNames: getTransition(viewSection) }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [viewSection === "overview" && ((0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true, className: "outputs-container__overview" }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Flex_1.Flex, __assign({ "data-ouia-component-id": "outputs-toolbar" }, { children: [(0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "primary", onClick: function (e) {
                                                        e.stopPropagation();
                                                        e.preventDefault();
                                                        addOutputField();
                                                    }, isDisabled: activeOperation !== EditorScorecard_1.Operation.NONE, icon: (0, jsx_runtime_1.jsx)(plus_icon_1.PlusIcon, {}), iconPosition: "left", ouiaId: "add-output" }, { children: "Add Output" })) }), (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", onClick: function () { return setViewSection("batch-add"); }, isDisabled: activeOperation !== EditorScorecard_1.Operation.NONE, icon: (0, jsx_runtime_1.jsx)(bolt_icon_1.BoltIcon, {}), iconPosition: "left" }, { children: "Add Multiple Outputs" })) })] })) }), validations && validations.length > 0 && ((0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Alert_1.Alert, { variant: "warning", isInline: true, title: (output === null || output === void 0 ? void 0 : output.OutputField.length)
                                            ? "Some items are invalid and need attention."
                                            : "At least one Output Field is required." }) })), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, __assign({ className: "outputs-container__fields-list", "data-ouia-component-id": "outputs-overview" }, { children: (0, jsx_runtime_1.jsx)(OutputFieldsTable_1.default, { modelIndex: modelIndex, outputs: output === null || output === void 0 ? void 0 : output.OutputField, selectedOutputIndex: selectedOutputIndex, setSelectedOutputIndex: setSelectedOutputIndex, validateOutputFieldName: validateOutputFieldName, viewExtendedProperties: function () { return setViewSection("extended-properties"); }, onAddOutputField: addOutputField, onDeleteOutputField: deleteOutputField, onCommitAndClose: onCommitAndClose, onCommit: onCommit, onCancel: onCancel }) }))] }))), viewSection === "extended-properties" && ((0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Text_1.TextContent, { children: (0, jsx_runtime_1.jsxs)(Title_1.Title, __assign({ size: "lg", headingLevel: "h1" }, { children: [(0, jsx_runtime_1.jsx)("a", __assign({ onClick: function () { return setViewSection("overview"); } }, { children: editItem === null || editItem === void 0 ? void 0 : editItem.name })), "\u00A0/\u00A0Properties"] })) }) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, __assign({ className: "outputs-container__extended-properties" }, { children: (0, jsx_runtime_1.jsx)(OutputFieldExtendedProperties_1.OutputFieldExtendedProperties, { modelIndex: modelIndex, activeOutputFieldIndex: selectedOutputIndex, activeOutputField: editItem, targetFields: targetFields, commit: onCommit }) })), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "primary", onClick: function () { return setViewSection("overview"); }, icon: (0, jsx_runtime_1.jsx)(arrow_alt_circle_left_icon_1.ArrowAltCircleLeftIcon, {}), iconPosition: "left" }, { children: "Back" })) })] }))), viewSection === "batch-add" && ((0, jsx_runtime_1.jsx)(OutputsBatchAdd_1.default, { onAdd: addBatchOutputs, onCancel: function () { return setViewSection("overview"); } }))] }) }), viewSection) })) })));
};
exports.OutputsContainer = OutputsContainer;
var getMiningSchemaTargetFields = function (miningSchema) {
    return miningSchema === null || miningSchema === void 0 ? void 0 : miningSchema.MiningField.filter(function (field) { return field.usageType === "target"; }).map(function (field) { return field.name; });
};
//# sourceMappingURL=OutputsContainer.js.map