"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinearRegressionView = exports.Range = exports.Line = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_charts_1 = require("@patternfly/react-charts");
var Line = (function () {
    function Line(m, c, title) {
        this.m = m;
        this.c = c;
        this.title = title;
    }
    return Line;
}());
exports.Line = Line;
var Range = (function () {
    function Range(min, max) {
        this.min = min;
        this.max = max;
    }
    return Range;
}());
exports.Range = Range;
var roundedToFixed = function (_float, _digits) {
    var rounded = Math.pow(10, _digits);
    return (Math.round(_float * rounded) / rounded).toFixed(_digits);
};
var getTicks = function (range, count) {
    var start = range.min;
    var end = range.max;
    var step = (end - start) / count;
    var ticks = new Array();
    var v = start;
    while (v <= end) {
        ticks.push(v);
        v = v + step;
    }
    if (ticks[ticks.length - 1] !== end) {
        ticks.push(end);
    }
    return ticks;
};
var LinearRegressionView = function (props) {
    var legendData = [];
    props.lines.forEach(function (line) {
        legendData.push({ name: line.title });
    });
    var _a = props.modelName, modelName = _a === void 0 ? "undefined" : _a, _b = props.width, width = _b === void 0 ? 500 : _b, _c = props.height, height = _c === void 0 ? 500 : _c;
    return ((0, jsx_runtime_1.jsx)("div", __assign({ style: { height: height, width: width } }, { children: (0, jsx_runtime_1.jsxs)(react_charts_1.Chart, __assign({ ariaTitle: modelName, containerComponent: (0, jsx_runtime_1.jsx)(react_charts_1.ChartVoronoiContainer, { labels: function (_a) {
                    var datum = _a.datum;
                    return "".concat(roundedToFixed(datum._x, 2), ", ").concat(roundedToFixed(datum._y, 2));
                }, constrainToVisibleArea: true }), legendData: legendData, legendOrientation: "horizontal", legendPosition: "bottom", padding: {
                bottom: 100,
                left: 50,
                right: 50,
                top: 50,
            }, height: height, width: width }, { children: [(0, jsx_runtime_1.jsx)(react_charts_1.ChartLabel, { text: modelName, x: width / 2, y: 30, textAnchor: "middle" }), (0, jsx_runtime_1.jsx)(react_charts_1.ChartAxis, { label: props.independentAxisTitle, showGrid: true, tickValues: getTicks(props.rangeX, 8), tickFormat: function (x) { return roundedToFixed(x, 2); } }), (0, jsx_runtime_1.jsx)(react_charts_1.ChartAxis, { label: props.dependentAxisTitle, dependentAxis: true, showGrid: true, tickValues: getTicks(props.rangeY, 8), tickFormat: function (x) { return roundedToFixed(x, 2); } }), (0, jsx_runtime_1.jsx)(react_charts_1.ChartGroup, { children: props.lines.map(function (line) {
                        return ((0, jsx_runtime_1.jsx)(react_charts_1.ChartLine, { samples: 100, domain: {
                                x: [props.rangeX.min, props.rangeX.max],
                                y: [props.rangeY.min, props.rangeY.max],
                            }, y: function (datum) { return line.m * datum.x + line.c; } }, line.title));
                    }) })] })) })));
};
exports.LinearRegressionView = LinearRegressionView;
//# sourceMappingURL=LinearRegressionView.js.map