"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharacteristicsContainer = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Operation_1 = require("../Operation");
var CharacteristicsTable_1 = require("./CharacteristicsTable");
require("./CharacteristicsContainer.scss");
var react_transition_group_1 = require("react-transition-group");
var reducers_1 = require("../../../reducers");
var molecules_1 = require("../molecules");
var lodash_1 = require("lodash");
var PMMLModelHelper_1 = require("../../../PMMLModelHelper");
var history_1 = require("../../../history");
var OperationContext_1 = require("../OperationContext");
var PredicateConverter_1 = require("./PredicateConverter");
var set = Reflect.set;
var get = Reflect.get;
var CharacteristicsContainer = function (props) {
    var modelIndex = props.modelIndex, areReasonCodesUsed = props.areReasonCodesUsed, scorecardBaselineScore = props.scorecardBaselineScore, characteristics = props.characteristics;
    var setActiveOperation = (0, OperationContext_1.useOperation)().setActiveOperation;
    var _a = (0, history_1.useHistoryService)(), service = _a.service, getCurrentState = _a.getCurrentState;
    var dispatch = (0, history_1.useBatchDispatch)(service, getCurrentState);
    var _b = __read((0, react_1.useState)(""), 2), filter = _b[0], setFilter = _b[1];
    var _c = __read((0, react_1.useState)([]), 2), filteredCharacteristics = _c[0], setFilteredCharacteristics = _c[1];
    var _d = __read((0, react_1.useState)(undefined), 2), selectedCharacteristicIndex = _d[0], setSelectedCharacteristicIndex = _d[1];
    var _e = __read((0, react_1.useState)(undefined), 2), selectedAttributeIndex = _e[0], setSelectedAttributeIndex = _e[1];
    var _f = __read((0, react_1.useState)("overview"), 2), viewSection = _f[0], setViewSection = _f[1];
    (0, react_1.useEffect)(function () { return applyFilter(); }, [modelIndex, characteristics]);
    var setLowercaseTrimmedFilter = function (_filter) {
        setFilter(_filter.toLowerCase().trim());
    };
    var applyFilter = function () {
        var _filteredCharacteristics = characteristics === null || characteristics === void 0 ? void 0 : characteristics.map(function (_characteristic, index) { return ({ index: index, characteristic: _characteristic }); }).filter(function (ic) {
            var _characteristicName = ic.characteristic.name;
            return _characteristicName === null || _characteristicName === void 0 ? void 0 : _characteristicName.toLowerCase().includes(filter);
        });
        setFilteredCharacteristics(_filteredCharacteristics !== null && _filteredCharacteristics !== void 0 ? _filteredCharacteristics : []);
    };
    var getTransition = function (_viewSection) {
        if (_viewSection === "overview") {
            return "characteristics-container__overview";
        }
        else {
            return "characteristics-container__attribute";
        }
    };
    var onViewOverviewView = function () {
        setActiveOperation(Operation_1.Operation.UPDATE_CHARACTERISTIC);
        setViewSection("overview");
    };
    var onViewAttribute = function (index) {
        if (index === undefined) {
            return;
        }
        setSelectedAttributeIndex(index);
        setViewSection("attribute");
    };
    var validateCharacteristicName = (0, react_1.useCallback)(function (editIndex, name) {
        if (name === undefined || name.trim() === "") {
            return false;
        }
        var matching = characteristics.filter(function (c, index) { return editIndex !== index && c.name === name; });
        return matching.length === 0;
    }, [characteristics]);
    var onAddCharacteristic = (0, react_1.useCallback)(function () {
        var numberOfCharacteristics = characteristics === null || characteristics === void 0 ? void 0 : characteristics.length;
        if (numberOfCharacteristics !== undefined) {
            setSelectedCharacteristicIndex(numberOfCharacteristics);
            var existingNames = characteristics.map(function (c) { var _a; return (_a = c.name) !== null && _a !== void 0 ? _a : ""; });
            var newCharacteristicName = (0, PMMLModelHelper_1.findIncrementalName)("New characteristic", existingNames, 1);
            dispatch({
                type: reducers_1.Actions.Scorecard_AddCharacteristic,
                payload: {
                    modelIndex: modelIndex,
                    name: newCharacteristicName,
                    baselineScore: undefined,
                    reasonCode: undefined,
                    Attribute: [],
                },
            });
            setActiveOperation(Operation_1.Operation.UPDATE_CHARACTERISTIC);
            setLowercaseTrimmedFilter("");
        }
    }, [characteristics]);
    var deleteCharacteristic = (0, react_1.useCallback)(function (characteristicIndex) {
        dispatch({
            type: reducers_1.Actions.Scorecard_DeleteCharacteristic,
            payload: {
                modelIndex: modelIndex,
                characteristicIndex: characteristicIndex,
            },
        });
    }, [characteristics]);
    var onAddAttribute = (0, react_1.useCallback)(function () {
        if (selectedCharacteristicIndex === undefined) {
            return;
        }
        var numberOfAttributes = characteristics[selectedCharacteristicIndex].Attribute.length;
        setSelectedAttributeIndex(numberOfAttributes);
        dispatch({
            type: reducers_1.Actions.Scorecard_AddAttribute,
            payload: {
                modelIndex: modelIndex,
                characteristicIndex: selectedCharacteristicIndex,
                predicate: (0, PredicateConverter_1.fromText)("True"),
                partialScore: undefined,
                reasonCode: undefined,
            },
        });
        setActiveOperation(Operation_1.Operation.UPDATE_ATTRIBUTE);
        setViewSection("attribute");
    }, [characteristics, selectedCharacteristicIndex]);
    var onCommitAndClose = function () {
        onCommit({});
        onCancel();
    };
    var onCommit = (0, react_1.useCallback)(function (partial) {
        if (selectedCharacteristicIndex === undefined) {
            return;
        }
        var characteristic = characteristics[selectedCharacteristicIndex];
        var existingPartial = {};
        Object.keys(partial).forEach(function (key) { return set(existingPartial, key, get(characteristic, key)); });
        if (!(0, lodash_1.isEqual)(partial, existingPartial)) {
            dispatch({
                type: reducers_1.Actions.Scorecard_UpdateCharacteristic,
                payload: __assign(__assign({ modelIndex: modelIndex, characteristicIndex: selectedCharacteristicIndex }, characteristic), partial),
            });
        }
    }, [characteristics, selectedCharacteristicIndex]);
    var onCancel = function () {
        setSelectedCharacteristicIndex(undefined);
        setActiveOperation(Operation_1.Operation.NONE);
    };
    var onUpdateAttribute = (0, react_1.useCallback)(function (_index, _content) {
        if (_index === undefined) {
            dispatch({
                type: reducers_1.Actions.Scorecard_AddAttribute,
                payload: {
                    modelIndex: modelIndex,
                    characteristicIndex: selectedCharacteristicIndex,
                    predicate: _content.predicate,
                    partialScore: _content.partialScore,
                    reasonCode: _content.reasonCode,
                },
            });
        }
        else {
            dispatch({
                type: reducers_1.Actions.Scorecard_UpdateAttribute,
                payload: {
                    modelIndex: modelIndex,
                    characteristicIndex: selectedCharacteristicIndex,
                    attributeIndex: selectedAttributeIndex,
                    predicate: _content.predicate,
                    partialScore: _content.partialScore,
                    reasonCode: _content.reasonCode,
                },
            });
        }
    }, [modelIndex, selectedCharacteristicIndex, selectedAttributeIndex]);
    var emptyStateProvider = (0, react_1.useMemo)(function () {
        if (characteristics.length === 0) {
            return (0, jsx_runtime_1.jsx)(molecules_1.EmptyStateNoCharacteristics, { addCharacteristic: onAddCharacteristic });
        }
        else {
            return ((0, jsx_runtime_1.jsx)(Stack_1.Stack, __assign({ hasGutter: true }, { children: (0, jsx_runtime_1.jsxs)(Stack_1.StackItem, { children: [(0, jsx_runtime_1.jsx)(molecules_1.CharacteristicsToolbar, { filter: filter, setFilter: setLowercaseTrimmedFilter, onFilter: applyFilter, onAddCharacteristic: onAddCharacteristic }), (0, jsx_runtime_1.jsx)(molecules_1.EmptyStateNoMatchingCharacteristics, {})] }) })));
        }
    }, [filter, characteristics]);
    return ((0, jsx_runtime_1.jsxs)("div", __assign({ className: "characteristics-container", "data-ouia-component-id": "characteristics" }, { children: [filteredCharacteristics.length === 0 && emptyStateProvider, filteredCharacteristics.length > 0 && ((0, jsx_runtime_1.jsx)(react_transition_group_1.SwitchTransition, __assign({ mode: "out-in" }, { children: (0, jsx_runtime_1.jsx)(react_transition_group_1.CSSTransition, __assign({ timeout: {
                        enter: 230,
                        exit: 100,
                    }, classNames: getTransition(viewSection) }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [viewSection === "overview" && ((0, jsx_runtime_1.jsxs)(Stack_1.Stack, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(molecules_1.CharacteristicsToolbar, { filter: filter, setFilter: setLowercaseTrimmedFilter, onFilter: applyFilter, onAddCharacteristic: onAddCharacteristic }) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, __assign({ className: "characteristics-container__overview" }, { children: (0, jsx_runtime_1.jsx)(CharacteristicsTable_1.CharacteristicsTable, { modelIndex: modelIndex, areReasonCodesUsed: areReasonCodesUsed, scorecardBaselineScore: scorecardBaselineScore, characteristics: filteredCharacteristics, characteristicsUnfilteredLength: characteristics.length, selectedCharacteristicIndex: selectedCharacteristicIndex, setSelectedCharacteristicIndex: setSelectedCharacteristicIndex, validateCharacteristicName: validateCharacteristicName, viewAttribute: onViewAttribute, deleteCharacteristic: deleteCharacteristic, onAddAttribute: onAddAttribute, onCommitAndClose: onCommitAndClose, onCommit: onCommit, onCancel: onCancel }) }))] })), viewSection === "attribute" && ((0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(molecules_1.AttributeToolbar, { viewOverview: onViewOverviewView }) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, __assign({ className: "characteristics-container__attribute" }, { children: (0, jsx_runtime_1.jsx)(molecules_1.AttributeEditor, { modelIndex: modelIndex, characteristicIndex: selectedCharacteristicIndex, attributeIndex: selectedAttributeIndex, areReasonCodesUsed: areReasonCodesUsed, onCancel: onViewOverviewView, onCommit: onUpdateAttribute }) }))] })))] }) }), viewSection) })))] })));
};
exports.CharacteristicsContainer = CharacteristicsContainer;
//# sourceMappingURL=CharacteristicsContainer.js.map