"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bootstrapMonaco = void 0;
var monaco = require("@kie-tools-core/monaco-editor");
var CompletionItemKind = monaco.languages.CompletionItemKind;
var CompletionItemInsertTextRule = monaco.languages.CompletionItemInsertTextRule;
var bootstrapMonaco = function () {
    var theme = {
        base: "vs",
        inherit: false,
        rules: [
            { token: "sc-numeric", foreground: "3232E7" },
            {
                token: "sc-boolean",
                foreground: "26268D",
                fontStyle: "bold",
            },
            {
                token: "sc-string",
                foreground: "2A9343",
                fontStyle: "bold",
            },
            {
                token: "sc-operator",
                foreground: "3232E8",
            },
            {
                token: "sc-keyword",
                foreground: "0000ff",
                fontStyle: "bold",
            },
        ],
        colors: { "editorLineNumber.foreground": "00ff00" },
    };
    var tokens = {
        tokenizer: {
            root: [
                {
                    regex: "[0-9]+",
                    action: "sc-numeric",
                },
                {
                    regex: "(?:(\\btrue\\b)|(\\bfalse\\b))",
                    action: "sc-boolean",
                },
                {
                    regex: "True|False",
                    action: "sc-keyword",
                },
                {
                    regex: '(?:\\"(?:.*?)\\")',
                    action: "sc-string",
                },
                {
                    regex: "==|!=|<|<=|>|>=|isMissing|isNotMissing",
                    action: "sc-operator",
                },
            ],
        },
    };
    var provider = {
        provideCompletionItems: function (model, position, context, token) {
            return {
                suggestions: [
                    {
                        label: "True",
                        insertText: "True",
                        kind: CompletionItemKind.Keyword,
                        insertTextRules: CompletionItemInsertTextRule.InsertAsSnippet,
                        range: { startLineNumber: 1, endLineNumber: 1, startColumn: 1, endColumn: 1 },
                    },
                    {
                        label: "False",
                        insertText: "False",
                        kind: CompletionItemKind.Keyword,
                        insertTextRules: CompletionItemInsertTextRule.InsertAsSnippet,
                        range: { startLineNumber: 1, endLineNumber: 1, startColumn: 1, endColumn: 1 },
                    },
                ],
            };
        },
    };
    monaco.editor.defineTheme("scorecards", theme);
    monaco.languages.register({ id: "scorecards" });
    monaco.languages.setMonarchTokensProvider("scorecards", tokens);
    monaco.languages.registerCompletionItemProvider("scorecards", provider);
};
exports.bootstrapMonaco = bootstrapMonaco;
//# sourceMappingURL=PredicateEditorSetup.js.map