"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharacteristicsToolbar = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Text_1 = require("@patternfly/react-core/dist/js/components/Text");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var InputGroup_1 = require("@patternfly/react-core/dist/js/components/InputGroup");
var Toolbar_1 = require("@patternfly/react-core/dist/js/components/Toolbar");
var search_icon_1 = require("@patternfly/react-icons/dist/js/icons/search-icon");
require("./CharacteristicsToolbar.scss");
var CharacteristicsToolbar = function (props) {
    var filter = props.filter, setFilter = props.setFilter, onFilter = props.onFilter, onAddCharacteristic = props.onAddCharacteristic;
    return ((0, jsx_runtime_1.jsx)(Toolbar_1.Toolbar, __assign({ id: "characteristics-toolbar", "data-testid": "characteristics-toolbar" }, { children: (0, jsx_runtime_1.jsx)(Toolbar_1.ToolbarContent, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true, style: { width: "100%" } }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Text_1.TextContent, { children: (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ size: "lg", headingLevel: "h1" }, { children: "Characteristics" })) }) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { isFilled: true, "data-ouia-component-type": "filler" }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Toolbar_1.ToolbarItem, { children: (0, jsx_runtime_1.jsx)(InputGroup_1.InputGroup, { children: (0, jsx_runtime_1.jsx)("form", __assign({ onSubmit: function (e) { return e.preventDefault(); } }, { children: (0, jsx_runtime_1.jsxs)("span", __assign({ style: { display: "flex" } }, { children: [(0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { id: "characteristics-filter-input", name: "characteristics-filter-input", "data-testid": "characteristics-toolbar__characteristics-filter", type: "search", "aria-label": "filter characteristics", placeholder: "Filter by name", value: filter, onChange: function (e) { return setFilter(e); } }), (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ id: "characteristics-filter", type: "submit", "data-testid": "characteristics-toolbar__submit", variant: Button_1.ButtonVariant.control, "aria-label": "filter button for filter input", onClick: function () { return onFilter(); } }, { children: (0, jsx_runtime_1.jsx)(search_icon_1.SearchIcon, {}) }))] })) })) }) }) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Toolbar_1.ToolbarItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ id: "add-characteristic-button", "data-testid": "characteristics-toolbar__add-characteristic", variant: "primary", onClick: function () { return onAddCharacteristic(); }, ouiaId: "add-characteristic" }, { children: "Add Characteristic" })) }) })] })) }) })));
};
exports.CharacteristicsToolbar = CharacteristicsToolbar;
//# sourceMappingURL=CharacteristicsToolbar.js.map