"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharacteristicsTableEditRow = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Tooltip_1 = require("@patternfly/react-core/dist/js/components/Tooltip");
var exclamation_circle_icon_1 = require("@patternfly/react-icons/dist/js/icons/exclamation-circle-icon");
var help_icon_1 = require("@patternfly/react-icons/dist/js/icons/help-icon");
require("./CharacteristicsTableRow.scss");
require("../../EditorScorecard/templates/ScorecardEditorPage.scss");
var organisms_1 = require("../organisms");
var react_cool_onclickoutside_1 = require("react-cool-onclickoutside");
var Operation_1 = require("../Operation");
var reducers_1 = require("../../../reducers");
var react_redux_1 = require("react-redux");
var pmml_editor_marshaller_1 = require("@kie-tools/pmml-editor-marshaller");
var history_1 = require("../../../history");
var OperationContext_1 = require("../OperationContext");
var paths_1 = require("../../../paths");
var validation_1 = require("../../../validation");
var lodash_1 = require("lodash");
var get = Reflect.get;
var set = Reflect.set;
var CharacteristicsTableEditRow = function (props) {
    var _a;
    var modelIndex = props.modelIndex, areReasonCodesUsed = props.areReasonCodesUsed, scorecardBaselineScore = props.scorecardBaselineScore, characteristic = props.characteristic, validateCharacteristicName = props.validateCharacteristicName, viewAttribute = props.viewAttribute, onAddAttribute = props.onAddAttribute, onCommitAndClose = props.onCommitAndClose, onCommit = props.onCommit, onCancel = props.onCancel;
    var characteristicIndex = characteristic.index;
    var activeOperation = (0, OperationContext_1.useOperation)().activeOperation;
    var _b = (0, history_1.useHistoryService)(), service = _b.service, getCurrentState = _b.getCurrentState;
    var dispatch = (0, history_1.useBatchDispatch)(service, getCurrentState);
    var _c = __read((0, react_1.useState)({
        value: undefined,
        valid: true,
    }), 2), name = _c[0], setName = _c[1];
    var _d = __read((0, react_1.useState)(), 2), reasonCode = _d[0], setReasonCode = _d[1];
    var _e = __read((0, react_1.useState)(), 2), baselineScore = _e[0], setBaselineScore = _e[1];
    var attributes = (0, react_redux_1.useSelector)(function (state) {
        var model = state.models ? state.models[modelIndex] : undefined;
        if (model instanceof pmml_editor_marshaller_1.Scorecard && characteristicIndex !== undefined) {
            var scorecard = model;
            var _characteristic = scorecard.Characteristics.Characteristic[characteristicIndex];
            if (_characteristic) {
                return _characteristic.Attribute;
            }
        }
        return [];
    });
    var isReasonCodeProvidedByAttributes = (0, react_1.useMemo)(function () {
        return attributes.length > 0 && attributes.every(function (attribute) { return attribute.reasonCode !== undefined; });
    }, [attributes]);
    var ref = (0, react_cool_onclickoutside_1.default)(function () {
        if (name === null || name === void 0 ? void 0 : name.valid) {
            onCommitAndClose();
        }
        else {
            onCancel();
        }
    }, {
        disabled: activeOperation !== Operation_1.Operation.UPDATE_CHARACTERISTIC,
        eventTypes: ["click"],
    });
    (0, react_1.useEffect)(function () {
        setName({
            value: characteristic === null || characteristic === void 0 ? void 0 : characteristic.characteristic.name,
            valid: true,
        });
        setReasonCode(characteristic === null || characteristic === void 0 ? void 0 : characteristic.characteristic.reasonCode);
        setBaselineScore(characteristic === null || characteristic === void 0 ? void 0 : characteristic.characteristic.baselineScore);
    }, [props]);
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var reasonCodeValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forReasonCode()
            .build());
    }, [modelIndex, characteristicIndex, areReasonCodesUsed, characteristic]);
    var baselineScoreValidation = (0, react_1.useMemo)(function () {
        return validationRegistry.get((0, paths_1.Builder)()
            .forModel(modelIndex)
            .forCharacteristics()
            .forCharacteristic(characteristicIndex)
            .forBaselineScore()
            .build());
    }, [modelIndex, characteristicIndex, scorecardBaselineScore, characteristic]);
    var toNumber = function (value) {
        if (value === "") {
            return undefined;
        }
        var n = Number(value);
        if (isNaN(n)) {
            return undefined;
        }
        return n;
    };
    var onDeleteAttribute = (0, react_1.useCallback)(function (attributeIndex) {
        dispatch({
            type: reducers_1.Actions.Scorecard_DeleteAttribute,
            payload: {
                modelIndex: modelIndex,
                characteristicIndex: characteristicIndex,
                attributeIndex: attributeIndex,
            },
        });
    }, [modelIndex, characteristicIndex]);
    var onUpdateAttribute = (0, react_1.useCallback)(function (attributeIndex, partial) {
        var attribute = attributes[attributeIndex];
        var existingPartial = {};
        Object.keys(partial).forEach(function (key) { return set(existingPartial, key, get(attribute, key)); });
        if (!(0, lodash_1.isEqual)(partial, existingPartial)) {
            dispatch({
                type: reducers_1.Actions.Scorecard_UpdateAttribute,
                payload: __assign(__assign({ modelIndex: modelIndex, characteristicIndex: characteristicIndex, attributeIndex: attributeIndex }, attribute), partial),
            });
        }
    }, [modelIndex, characteristicIndex, attributes]);
    return ((0, jsx_runtime_1.jsx)("article", __assign({ ref: ref, className: "editable-item__inner", tabIndex: 0, "data-ouia-component-id": "edit-characteristic" }, { children: (0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Name", isRequired: true, fieldId: "characteristic-form-name-helper", helperTextInvalid: "Name is mandatory and must be unique", helperTextInvalidIcon: (0, jsx_runtime_1.jsx)(exclamation_circle_icon_1.ExclamationCircleIcon, {}), validated: name.valid ? "default" : "error", style: { width: "18em" } }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "characteristic-name", name: "characteristic-name", "aria-describedby": "characteristic-name-helper", value: (_a = name.value) !== null && _a !== void 0 ? _a : "", placeholder: "Name", validated: name.valid ? "default" : "error", autoFocus: true, onChange: function (e) {
                                            return setName({
                                                value: e,
                                                valid: validateCharacteristicName(e),
                                            });
                                        }, onBlur: function () {
                                            if (name === null || name === void 0 ? void 0 : name.valid) {
                                                onCommit({
                                                    name: name.value,
                                                });
                                            }
                                            else {
                                                setName({
                                                    value: characteristic.characteristic.name,
                                                    valid: validateCharacteristicName(characteristic.characteristic.name),
                                                });
                                            }
                                        }, ouiaId: "characteristic-name-input" }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Reason code", fieldId: "characteristic-reason-code-helper", style: { width: "16em" }, labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: areReasonCodesUsed && isReasonCodeProvidedByAttributes
                                            ? "A Reason code is already provided inside all the Attributes of this Characteristic"
                                            : "\n                          Reason code is available and required when Use reason codes property inside Model Setup is yes.                           You can enter Reason code here or provide a Reason code for all the Attributes of this                           characteristic as an alternative." }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More information for Reason code", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })), validated: reasonCodeValidation.length > 0 ? "warning" : "default", helperText: reasonCodeValidation.length > 0 ? reasonCodeValidation[0].message : undefined }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "text", id: "characteristic-reason-code", name: "characteristic-reason-code", "aria-describedby": "characteristic-reason-code-helper", value: reasonCode !== null && reasonCode !== void 0 ? reasonCode : "", onChange: function (e) { return setReasonCode(e); }, onBlur: function () {
                                            onCommit({
                                                reasonCode: reasonCode === "" ? undefined : reasonCode,
                                            });
                                        }, validated: reasonCodeValidation.length > 0 ? "warning" : "default", isDisabled: !areReasonCodesUsed || isReasonCodeProvidedByAttributes, ouiaId: "characteristic-reason-code-input" }) })) }), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, __assign({ isFilled: true }, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Baseline score", fieldId: "characteristic-baseline-score-helper", labelIcon: (0, jsx_runtime_1.jsx)(Tooltip_1.Tooltip, __assign({ content: areReasonCodesUsed && scorecardBaselineScore !== undefined
                                            ? "A baseline score is already provided inside Model Setup"
                                            : "\n                          Baseline score for Characteristics is required when Use reason codes property is true                           and no Baseline score is provided inside Model Setup\n                          " }, { children: (0, jsx_runtime_1.jsx)("button", __assign({ "aria-label": "More information for Baseline score", onClick: function (e) { return e.preventDefault(); }, className: "pf-c-form__group-label-help" }, { children: (0, jsx_runtime_1.jsx)(help_icon_1.HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) })) })), helperText: baselineScoreValidation.length > 0 ? baselineScoreValidation[0].message : undefined, validated: baselineScoreValidation.length > 0 ? "warning" : "default", style: { width: "16em" } }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "number", id: "characteristic-baseline-score", name: "characteristic-baseline-score", "aria-describedby": "characteristic-baseline-score-helper", value: baselineScore !== null && baselineScore !== void 0 ? baselineScore : "", validated: baselineScoreValidation.length > 0 ? "warning" : "default", onChange: function (e) { return setBaselineScore(toNumber(e)); }, onBlur: function () {
                                            onCommit({
                                                baselineScore: baselineScore,
                                            });
                                        }, isDisabled: scorecardBaselineScore !== undefined, ouiaId: "characteristic-baseline-score-input" }) })) })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ id: "add-attribute-button", variant: "primary", onClick: onAddAttribute, ouiaId: "add-attribute" }, { children: "Add Attribute" })) })] })) }), attributes.length > 0 && ((0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Attributes", fieldId: "output-labels-helper" }, { children: (0, jsx_runtime_1.jsx)(organisms_1.AttributesTable, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic.characteristic, areReasonCodesUsed: areReasonCodesUsed, viewAttribute: viewAttribute, deleteAttribute: onDeleteAttribute, onCommit: onUpdateAttribute }) })) }))] })) })));
};
exports.CharacteristicsTableEditRow = CharacteristicsTableEditRow;
//# sourceMappingURL=CharacteristicsTableEditRow.js.map