"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Text_1 = require("@patternfly/react-core/dist/js/components/Text");
var TextInput_1 = require("@patternfly/react-core/dist/js/components/TextInput");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var Stack_1 = require("@patternfly/react-core/dist/js/layouts/Stack");
var Split_1 = require("@patternfly/react-core/dist/js/layouts/Split");
var Form_1 = require("@patternfly/react-core/dist/js/components/Form");
var Checkbox_1 = require("@patternfly/react-core/dist/js/components/Checkbox");
var trash_icon_1 = require("@patternfly/react-icons/dist/js/icons/trash-icon");
require("./ConstraintsRangeEdit.scss");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
var ConstraintsRangeEdit = function (props) {
    var dataFieldIndex = props.dataFieldIndex, ranges = props.ranges, onAdd = props.onAdd, onChange = props.onChange, onDelete = props.onDelete, countLimit = props.countLimit;
    var _a = __read((0, react_1.useState)(), 2), addedRange = _a[0], setAddedRange = _a[1];
    var updateRange = function (index, range) {
        var newRanges = __spreadArray([], __read(ranges), false);
        newRanges[index] = range;
        onChange(newRanges);
    };
    var addRange = function () {
        onAdd();
        setAddedRange(ranges.length);
    };
    var updateAddedRange = function (position) {
        setAddedRange(position);
    };
    return ((0, jsx_runtime_1.jsxs)(Stack_1.Stack, __assign({ hasGutter: true }, { children: [(0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Text_1.TextContent, { children: (0, jsx_runtime_1.jsx)(Text_1.Text, __assign({ component: Text_1.TextVariants.small }, { children: "At least the Start Value or End Value is required for each interval" })) }) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: ranges.map(function (range, index) { return ((0, jsx_runtime_1.jsx)(RangeEdit, { dataFieldIndex: dataFieldIndex, range: range, rangesCount: ranges.length, index: index, onSave: updateRange, onDelete: onDelete, addedRange: addedRange, updateAddedRange: updateAddedRange }, index)); }) }), (0, jsx_runtime_1.jsx)(Stack_1.StackItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", onClick: addRange, isDisabled: countLimit !== undefined && ranges.length >= countLimit, isSmall: true, ouiaId: "add-another-interval" }, { children: "Add another interval" })) })] })));
};
exports.default = ConstraintsRangeEdit;
var RangeEdit = function (props) {
    var dataFieldIndex = props.dataFieldIndex, range = props.range, rangesCount = props.rangesCount, index = props.index, onSave = props.onSave, onDelete = props.onDelete, addedRange = props.addedRange, updateAddedRange = props.updateAddedRange;
    var _a = __read((0, react_1.useState)(range), 2), rangeValues = _a[0], setRangeValues = _a[1];
    var _b = __read((0, react_1.useState)(false), 2), submitChanges = _b[0], setSubmitChanges = _b[1];
    var handleRangeChange = function (value, event) {
        switch (event.target.name) {
            case "start-value":
                setRangeValues(__assign(__assign({}, rangeValues), { start: __assign(__assign({}, rangeValues.start), { value: value }) }));
                break;
            case "start-included":
                setRangeValues(__assign(__assign({}, rangeValues), { start: __assign(__assign({}, rangeValues.start), { included: value }) }));
                break;
            case "end-value":
                setRangeValues(__assign(__assign({}, rangeValues), { end: __assign(__assign({}, rangeValues.end), { value: value }) }));
                break;
            case "end-included":
                setRangeValues(__assign(__assign({}, rangeValues), { end: __assign(__assign({}, rangeValues.end), { included: value }) }));
                break;
            default:
                break;
        }
    };
    var handleDelete = function () {
        onDelete(index);
    };
    var saveChange = function () {
        setSubmitChanges(true);
    };
    var rangeRef = (0, react_1.useRef)(null);
    (0, react_1.useEffect)(function () {
        if (submitChanges) {
            onSave(index, rangeValues);
            setSubmitChanges(false);
        }
    }, [submitChanges, rangeValues]);
    (0, react_1.useEffect)(function () {
        setRangeValues(range);
    }, [range]);
    (0, react_1.useEffect)(function () {
        if (rangeRef.current && addedRange === index) {
            var container = document.querySelector(".data-dictionary__properties-edit__form .constraints__form");
            container === null || container === void 0 ? void 0 : container.scroll({ top: container === null || container === void 0 ? void 0 : container.scrollHeight, behavior: "smooth" });
            updateAddedRange(undefined);
        }
    }, [addedRange, index, rangeRef.current]);
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forDataDictionary().forDataField(dataFieldIndex).forInterval(index).build()); }, [range]);
    return ((0, jsx_runtime_1.jsx)("section", __assign({ ref: rangeRef, "data-ouia-component-id": "interval-".concat(index), "data-ouia-component-type": "interval-item" }, { children: (0, jsx_runtime_1.jsxs)(Split_1.Split, __assign({ hasGutter: true, className: "constraints__range-item" }, { children: [(0, jsx_runtime_1.jsxs)(Split_1.SplitItem, __assign({ isFilled: true }, { children: [(0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "Start Value", fieldId: "start-value-".concat(index), helperText: validations[0] ? "Please enter start and/or end value" : "" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "number", id: "start-value-".concat(index), name: "start-value", value: rangeValues.start.value, validated: validations.length === 0 ? "default" : "warning", onChange: handleRangeChange, onBlur: saveChange, tabIndex: (index + 1) * 10 + 1, autoComplete: "off", ouiaId: "start-value" }) })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ fieldId: "start-included-".concat(index), className: "constraints__include-range" }, { children: (0, jsx_runtime_1.jsx)(Checkbox_1.Checkbox, { label: "Include Start Value", "aria-label": "Include Start Value", id: "start-included-".concat(index), name: "start-included", isChecked: rangeValues.start.included, onChange: handleRangeChange, onClick: saveChange, tabIndex: (index + 1) * 10 + 3, ouiaId: "is-start-included" }) }))] })), (0, jsx_runtime_1.jsxs)(Split_1.SplitItem, __assign({ isFilled: true }, { children: [(0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ label: "End Value", fieldId: "end-value-".concat(index), helperText: validations[0] ? "Please enter start and/or end value" : "" }, { children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { type: "number", id: "end-value-".concat(index), name: "end-value", value: rangeValues.end.value, validated: validations.length === 0 ? "default" : "warning", onChange: handleRangeChange, onBlur: saveChange, tabIndex: (index + 1) * 10 + 2, autoComplete: "off", ouiaId: "end-value" }) })), (0, jsx_runtime_1.jsx)(Form_1.FormGroup, __assign({ fieldId: "end-included-".concat(index), className: "constraints__include-range" }, { children: (0, jsx_runtime_1.jsx)(Checkbox_1.Checkbox, { label: "Include End Value", "aria-label": "Include End Value", id: "end-included-".concat(index), name: "end-included", isChecked: rangeValues.end.included, onChange: handleRangeChange, onClick: saveChange, tabIndex: (index + 1) * 10 + 4, ouiaId: "is-end-included" }) }))] })), (0, jsx_runtime_1.jsx)(Split_1.SplitItem, { children: (0, jsx_runtime_1.jsx)(Flex_1.Flex, __assign({ alignItems: { default: "alignItemsCenter" }, justifyContent: { default: "justifyContentCenter" }, style: { height: "100%" } }, { children: (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "plain", "aria-label": "Delete Range", onClick: handleDelete, isDisabled: rangesCount === 1, tabIndex: (index + 1) * 10 + 5, ouiaId: "delete-item" }, { children: (0, jsx_runtime_1.jsx)(trash_icon_1.TrashIcon, {}) })) }) })) })] })) })));
};
//# sourceMappingURL=ConstraintsRangeEdit.js.map