"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
var lodash_1 = require("lodash");
var DataDictionaryContainer_1 = require("../DataDictionaryContainer/DataDictionaryContainer");
var atoms_1 = require("../../EditorCore/atoms");
var validation_1 = require("../../../validation");
var paths_1 = require("../../../paths");
require("./ConstraintsLabel.scss");
var ConstraintsLabel = function (props) {
    var dataType = props.dataType, dataTypeIndex = props.dataTypeIndex, _a = props.editMode, editMode = _a === void 0 ? false : _a, onConstraintsDelete = props.onConstraintsDelete;
    var onClose = (0, react_1.useMemo)(function () {
        if (editMode && !areConstraintsRequired(dataType)) {
            return function (event) {
                event.nativeEvent.stopImmediatePropagation();
                onConstraintsDelete === null || onConstraintsDelete === void 0 ? void 0 : onConstraintsDelete();
            };
        }
    }, [dataTypeIndex, dataType]);
    var missingRequiredConstraints = (0, react_1.useMemo)(function () {
        return !dataType.constraints && areConstraintsRequired(dataType);
    }, [dataType]);
    var constraintValue = (0, react_1.useMemo)(function () {
        if (dataType.constraints) {
            switch (dataType.constraints.type) {
                case DataDictionaryContainer_1.ConstraintType.RANGE:
                    return dataType.constraints.value
                        .map(function (range) {
                        return ("".concat(range.start.included ? "[" : "(") +
                            "".concat(range.start.value || "".concat(String.fromCharCode(8722, 8734)), ", ") +
                            "".concat(range.end.value || "".concat(String.fromCharCode(43, 8734))) +
                            "".concat(range.end.included ? "]" : ")"));
                    })
                        .join(" ");
                case DataDictionaryContainer_1.ConstraintType.ENUMERATION:
                    if ((0, lodash_1.every)(dataType.constraints.value, function (value) { return value === ""; })) {
                        return (0, jsx_runtime_1.jsx)("em", { children: "No values" });
                    }
                    return dataType.constraints.value.map(function (item) { return "\"".concat(item, "\""); }).join(", ");
                default:
                    return "";
            }
        }
        return "";
    }, [dataType.constraints]);
    var validationRegistry = (0, validation_1.useValidationRegistry)().validationRegistry;
    var validations = (0, react_1.useMemo)(function () { return validationRegistry.get((0, paths_1.Builder)().forDataDictionary().forDataField(dataTypeIndex).build()); }, [dataTypeIndex, dataType]);
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [missingRequiredConstraints && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorLabel, __assign({ validations: validations, cssClass: "constraints-label" }, { children: (0, jsx_runtime_1.jsx)("em", { children: "Missing required constraints" }) }))), !missingRequiredConstraints && dataType.constraints && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [validations.length > 0 && ((0, jsx_runtime_1.jsx)(atoms_1.ValidationIndicatorLabel, __assign({ validations: validations, onClose: onClose, cssClass: "constraints-label", "data-ouia-component-id": "invalid-constraints", "data-ouia-component-type": "data-props-label" }, { children: (0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "Constraints:" }), "\u00A0", (0, jsx_runtime_1.jsx)("span", { children: constraintValue })] }) }))), validations.length === 0 && ((0, jsx_runtime_1.jsxs)(Label_1.Label, __assign({ color: "cyan", className: "constraints-label", onClose: onClose, "data-ouia-component-id": "constraints", "data-ouia-component-type": "data-props-label" }, { children: [(0, jsx_runtime_1.jsx)("strong", { children: "Constraints:" }), "\u00A0", (0, jsx_runtime_1.jsx)("span", { children: constraintValue })] })))] }))] }));
};
exports.default = ConstraintsLabel;
var areConstraintsRequired = function (dataType) {
    return dataType.isCyclic || (dataType.type === "string" && dataType.optype === "ordinal");
};
//# sourceMappingURL=ConstraintsLabel.js.map