import React, { useMemo } from "react";
import { WorkflowDefinitionListContext } from "./WorkflowDefinitionListContext";
import { WorkflowDefinitionListGatewayApiImpl } from "./WorkflowDefinitionListGatewayApi";
import { HttpLink } from "apollo-link-http";
import { InMemoryCache } from "apollo-cache-inmemory";
import { ApolloClient } from "apollo-client";
import { GraphQLWorkflowDefinitionListQueries } from "./WorkflowDefinitionListQueries";
export function WorkflowDefinitionListContextProvider(props) {
    const { proxyEndpoint, dataIndexUrl } = props;
    const httpLink = useMemo(() => new HttpLink({
        uri: proxyEndpoint || dataIndexUrl,
        headers: Object.assign({}, (proxyEndpoint ? { "Target-Url": dataIndexUrl } : {})),
    }), [dataIndexUrl, proxyEndpoint]);
    const cache = useMemo(() => new InMemoryCache(), []);
    const apolloClient = useMemo(() => new ApolloClient({
        cache,
        link: httpLink,
    }), [cache, httpLink]);
    return (React.createElement(WorkflowDefinitionListContextProviderWithApolloClient, { apolloClient: apolloClient }, props.children));
}
export function WorkflowDefinitionListContextProviderWithApolloClient(props) {
    const { apolloClient } = props;
    const gatewayApiImpl = useMemo(() => {
        return new WorkflowDefinitionListGatewayApiImpl(new GraphQLWorkflowDefinitionListQueries(apolloClient));
    }, [apolloClient]);
    return (React.createElement(WorkflowDefinitionListContext.Provider, { value: gatewayApiImpl }, props.children));
}
//# sourceMappingURL=WorkflowDefinitionListContextProvider.js.map