import React, { useMemo } from "react";
import CloudEventFormContext from "./CloudEventFormContext";
import { CloudEventFormGatewayApiImpl } from "./CloudEventFormGatewayApi";
export function CloudEventFormContextProvider(props) {
    const { proxyEndpoint } = props;
    const gatewayApi = useMemo(() => new CloudEventFormGatewayApiImpl(proxyEndpoint), [proxyEndpoint]);
    return React.createElement(CloudEventFormContext.Provider, { value: gatewayApi }, props.children);
}
export default CloudEventFormContextProvider;
//# sourceMappingURL=CloudEventFormContextProvider.js.map